% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cache_browse}
\alias{cache_browse}
\alias{cache_info}
\alias{cache_prune}
\title{Cache management}
\usage{
cache_browse()

cache_info()

cache_prune(days = 30)
}
\arguments{
\item{days}{Number of days to preserve cached data; any pin versions
older than \code{days} will be removed.}
}
\description{
Most boards maintain a local cache so that if you're reading a pin
that hasn't changed since the last time you read it, it can be rapidly
retrieved from a local cache. These functions help you manage that cache.
\itemize{
\item \code{cache_browse()}: open the cache directory for interactive exploration.
\item \code{cache_info()}: report how much disk space each board's cache uses.
\item \code{cache_prune()}: delete pin versions that you haven't used for \code{days}
(you'll be asked to confirm before the deletion happens).
}

In general, there's no real harm to deleting the cached pins, as they'll
be re-downloaded as needed. The one exception is \code{\link[=legacy_local]{legacy_local()}} which
mistakenly stored its pinned data in the cache directory; do not touch
this directory.
}
