% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin_reactive.R
\name{pin_reactive_read}
\alias{pin_reactive_read}
\alias{pin_reactive_download}
\title{Wrap a pin in a reactive expression}
\usage{
pin_reactive_read(board, name, interval = 5000)

pin_reactive_download(board, name, interval = 5000)
}
\arguments{
\item{board}{A pin board, created by \code{\link[=board_folder]{board_folder()}}, \code{\link[=board_rsconnect]{board_rsconnect()}},
\code{\link[=board_url]{board_url()}} or another \code{board_} function.}

\item{name}{Pin name.}

\item{interval}{Approximate number of milliseconds to wait between
re-downloading the pin metadata to check if anything has changed.}
}
\description{
\code{pin_reactive_read()} and \code{pin_reactive_download()} wrap the results of
\code{\link[=pin_read]{pin_read()}} and \code{\link[=pin_download]{pin_download()}} into a Shiny reactive. This allows you to
use pinned data within your app, and have the results automatically
recompute when the pin is modified.
}
\examples{
if (FALSE) {
  library(shiny)
  ui <- fluidPage(
    tableOutput("table")
  )

  server <- function(input, output, session) {
    board <- board_local()
    data <- pin_reactive_read(board, "shiny", interval = 1000)
    output$table <- renderTable(data())
  }
  shinyApp(ui, server)
}
}
