% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_kaggle.R
\name{board_kaggle}
\alias{board_kaggle}
\alias{board_kaggle_competitions}
\alias{pin_search.pins_board_kaggle_competition}
\alias{board_kaggle_dataset}
\alias{pin_search.pins_board_kaggle_dataset}
\alias{pin_store.pins_board_kaggle_dataset}
\title{Use kaggle datasets/competitions as a board}
\usage{
board_kaggle_competitions(username = NULL, key = NULL, cache = NULL)

\method{pin_search}{pins_board_kaggle_competition}(
  board,
  search = NULL,
  sort_by = c("grouped", "prize", "earliestDeadline", "latestDeadline", "numberOfTeams",
    "recentlyCreated"),
  page = 1,
  user = NULL,
  ...
)

board_kaggle_dataset(username = NULL, key = NULL, cache = NULL)

\method{pin_search}{pins_board_kaggle_dataset}(
  board,
  search = NULL,
  sort_by = c("hottest", "votes", "updated", "active"),
  page = 1,
  user = NULL,
  ...
)

\method{pin_store}{pins_board_kaggle_dataset}(
  board,
  name,
  paths,
  metadata,
  versioned = NULL,
  ...,
  private = TRUE,
  license = "CC0-1.0"
)
}
\arguments{
\item{username, key}{Typically you'll authenticate using the
\code{"~/.kaggle/kaggle.json"} file downloaded from your account page
(by clicking "Create New API Token". However, if necessary you can supply
the \code{username} and \code{key} arguments here; this can be useful for testing.}

\item{cache}{Cache path. Every board requires a local cache to avoid
downloading files multiple times. The default stores in a standard
cache location for your operating system, but you can override if needed.}

\item{board}{The name of the board to register.}

\item{search}{A string to search for in pin name and title.
Use \code{NULL} to return all pins.}

\item{sort_by}{How to sort the results.}

\item{page}{Which page of results to retrieve.}

\item{user}{If non-\code{NULL} filter to specified user.}

\item{...}{Additional parameters required to initialize a particular board.}

\item{name}{An optional name used identify the board. This is no longer
generally needed since you should be passing around an explicit
board object.}

\item{paths}{A character vector of file paths to upload to \code{board}.}

\item{metadata}{A list containing additional metadata to store with the pin.
When retrieving the pin, this will be stored in the \code{user} key, to
avoid potential clashes with the metadata that pins itself uses.}

\item{versioned}{Should this board be registered with support for versions?}

\item{private}{Should the dataset be private (\code{TRUE}, the default)
or public (\code{FALSE})?}

\item{license}{How should the data be licensed?}
}
\description{
\code{board_kaggle_competition()} allows you to treat a Kaggle competition like
a read-only board, making it easy get the data on to your computer.
\code{board_kaggle_dataset()} lets you upload and download files to and from a
kaggle dataset. Data is only re-downloaded when it changes.

These boards work best with \code{pin_download()} and \code{pin_upload()} since
\code{pin_read()} and \code{pin_write()} are not a good fit to the kaggle model.
}
\examples{
\dontrun{
board <- board_kaggle_competitions()
board

board \%>\% pin_meta("titanic")
paths <- board \%>\% pin_download("titanic")
paths
head(read.csv(paths[[1]]))
head(read.csv(paths[[2]]))
}
\dontrun{
board <- board_kaggle_dataset()

board \%>\% pin_search("cats")
board \%>\% pin_exists("rturley/pet-breed-characteristics")
board \%>\% pin_meta("rturley/pet-breed-characteristics")
board \%>\% pin_versions("rturley/pet-breed-characteristics")

board \%>\% pin_versions("imsparsh/animal-breed-cats-and-dogs")
}
}
