% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin_list.R
\name{pin_list}
\alias{pin_list}
\title{List all pins}
\usage{
pin_list(board, ...)
}
\arguments{
\item{board}{A pin board, created by \code{\link[=board_folder]{board_folder()}}, \code{\link[=board_rsconnect]{board_rsconnect()}},
\code{\link[=board_url]{board_url()}} or another \code{board_} function.}

\item{...}{Other arguments passed on to methods}
}
\value{
A character vector
}
\description{
List names of all pins in a board. This is a low-level function; use
\code{\link[=pin_search]{pin_search()}} to get more data about each pin in a convenient form.
}
\examples{
board <- board_temp()

board \%>\% pin_write(1:5, "x")
board \%>\% pin_write(letters, "y")
board \%>\% pin_write(runif(20), "z")

board \%>\% pin_list()
}
