% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_taxonomy.R
\name{filter_taxonomy}
\alias{filter_taxonomy}
\title{Filter taxonomy}
\usage{
filter_taxonomy(consensus, min_confidence = 80)
}
\arguments{
\item{consensus}{A list object that contains two slots each with an equal
sized vector. The \code{taxonomy} vector contains the
classification at each taxonomic level and the \code{confidence}
vector contains the percentage of bootstraps that had the
specified classification}

\item{min_confidence}{A double value between 0 and 100 (default = 80). The
minimum percentage of bootstrap replicates that had
the same classification. Any confidence score below
this value will have the corresponding taxonomy
removed}
}
\value{
A list object containing two equally sized vectors that are filtered
to remove low confidence taxonomies. One vector, \code{taxonomy},
contains the taxonomy at each taxonomic level and the other vector,
\code{confidence} contains the confidence score for that taxonomy. There
will be no taxonomies or confidence scores below \code{min_confidence}
}
\description{
The \code{filter_taxonomy()} function will filter a consensus taxonomy to remove
any taxonomic levels where the confidence score is below a \code{min_confidence}
level
}
\examples{
oscillospiraceae <- list(
  taxonomy = c(
    "Bacteria", "Bacillota", "Clostridia",
    "Eubacteriales", "Oscillospiraceae",
    "Flintibacter"
  ),
  confidence = c(100, 100, 99, 99, 98, 58)
)

filter_taxonomy(oscillospiraceae, min_confidence = 80)
}
