% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta.grid.R
\name{delta.grid}
\alias{delta.grid}
\title{Delta of Diversity Metrics}
\usage{
delta.grid(r1, r2, filename = NULL, cores = 1, ...)
}
\arguments{
\item{r1}{SpatRaster. Rasterized diversity metrics for time 1 (e.g
phylogenetic diversity in present). To calculate some diversity metrics for
rasters see phyloraster::geo.phylo function.}

\item{r2}{SpatRaster. Rasterized diversity metrics for time 2 (e.g
phylogenetic diversity in future).}

\item{filename}{character. Output filename.}

\item{cores}{positive integer. If cores > 1, a 'parallel' package cluster
with that many cores is created and used.}

\item{...}{additional arguments to be passed passed down from a calling
function.}
}
\value{
SpatRaster
}
\description{
Calculates the difference of rasterized diversity metrics
(richness, phylogenetic endemism, phylogenetic diversity, weighted endemism,
evolutionary distinctiveness) between time periods.
}
\details{
The two input rasters (r1 and r2) must have the same extent
and resolution.
}
\examples{
\donttest{
# data
x <- terra::rast(system.file("extdata", "rast.presab.tif",
package="phyloraster"))
tree <- ape::read.tree(system.file("extdata", "tree.nex",
package="phyloraster"))

# metric SR richness
riq.pres <- rast.sr(x)
# imagine we lost some species in the future
riq.fut <- rast.sr(x[[c(1:15)]])
dg <- delta.grid(riq.pres, riq.fut)
terra::plot(dg)
}
}
