% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylopath.R
\name{phylo_path}
\alias{phylo_path}
\title{Compare causal models in a phylogenetic context.}
\usage{
phylo_path(models, data, tree, order = NULL, cor_fun = ape::corPagel)
}
\arguments{
\item{models}{A list of directed acyclic graphs. These are matrices,
typically created with \code{DAG}.}

\item{data}{A \code{data.frame} with data.}

\item{tree}{A phylogenetic tree of class \code{pylo}.}

\item{order}{Causal order of the included variable, given as a character
vector. This is used to determine which variable should be the dependent
in the dsep regression equations. If left unspecified, the order will be
automatically determined. If the combination of all included models is
itself a DAG, then the ordering of that full model is used. Otherwise,
the most common ordering between each pair of variables is used to create
a general ordering.}

\item{cor_fun}{A function that creates a \code{corStruct} object, typically
one of the cor function from the \code{ape}, such as \code{corBrownian},
\code{corPagel} etc.}
}
\value{
A table with relevant statistics for each model, including the C
  statistic, the associated p-values, information criterions, and model
  weigths.
}
\description{
Compare causal models in a phylogenetic context.
}
\examples{
  #see vignette('intro_to_phylopath') for more details
  candidates <- list(A = DAG(LS ~ BM, NL ~ BM, DD ~ NL),
                     B = DAG(LS ~ BM, NL ~ LS, DD ~ NL))
  p <- phylo_path(candidates, rhino, rhino_tree)

  # Printing p gives some general information:
  p
  # And the summary gives statistics to compare the models:
  summary(p)

}

