% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/far.red.r
\name{Far_red}
\alias{Far_red}
\title{Constructor of far-red waveband}
\usage{
Far_red(std = "ISO")
}
\arguments{
\item{std}{a character string, defaults to "ISO", as for other colour
definitions, which in this case returns \code{NA}.}
}
\value{
An object of class \code{waveband}, a class defined in package
  'photobiology'.
}
\description{
Far-red radiation has no standardized definitions. Far-red is important in photobiology of plants
mainly in relation to the phytochrome photoreceptors. The definitions proposed
by Prof. Harry Smith are the most widely used, specially to compute a red to
far-red photon ratio. However, other authors have used different definitions
in their publications. These other definitions are preferred in situations
where phytochromes are not the target of study. For example the "red edge"
is is used in remote sensing to detect the condition of vegetation.
plant photobiology, "Smith10" (725-735 nm), "Smith20" (720-740 nm), "Inada"
(700-800 nm), "Warrington" (700-850 nm), and "Sellaro" (700-750 nm). The
red-edge used in remote sensing of vegetation is centred at the reflectance
transition in the far-red band (725 nm), we define "RedEdge40"
(705-745 nm) and "RedEdge20" (715-735 nm).
}
\note{
The bands are defined as square windows, these can be applied to
  spectral data to obtain the "true" values, but they do not simulate the
  sensitivity of broad-band sensors or the spectral transmittance of ionic
  filters. Some band-pass interference filters may have very sharp cut-in and
  cut-off, and their effect can be approximated by a square window, but
  filters based on light absorption will show gradual tails and bell-shaped
  wavelength-windows. The Landsat instruments have very steep cut-in anf
  cut-off slopes and are well approximated.
}
\examples{
Far_red() # no ISO definition exists
Far_red("ISO") # no ISO definition exists
Far_red("Smith10") # 10 nm wide
Far_red("Smith20") # 20 nm wide
Far_red("Inada")
Far_red("Warrington")
Far_red("Sellaro")
Far_red("RedEdge40")
Far_red("RedEdge20")

}
\seealso{
\code{\link{NIR}} for wavebands close to the boundary between red
  and infrared regions.

\code{\link[photobiology]{waveband}}

Other unweighted wavebands: 
\code{\link{Blue}()},
\code{\link{Green}()},
\code{\link{IR}()},
\code{\link{Orange}()},
\code{\link{Purple}()},
\code{\link{Red}()},
\code{\link{UVA}()},
\code{\link{UVB}()},
\code{\link{UVC}()},
\code{\link{UV}()},
\code{\link{VIS}()},
\code{\link{Yellow}()}
}
\concept{unweighted wavebands}
