% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.g.q.fun.r
\name{GEN_G_q_fun}
\alias{GEN_G_q_fun}
\title{Gives values for GPAS BSWF (Green's formulation) as a function of wavelength}
\usage{
GEN_G_q_fun(w.length)
}
\arguments{
\item{w.length}{numeric array of w.length (nm)}
}
\value{
a numeric array of the same length as \code{w.length} with values for the BSWF normalized
as in the original source.  The returned values are based on quantum effectiveness units.
}
\description{
This function gives a set of numeric multipliers that can be used
as a weight to calculate effective doses and irradiances. The BSWF is normalized
at 280 nm.
}
\note{
In the original publication [2] describing the formulation, the long-end
wavelength boundary is specified as 313.3 nm. The equation
is coded here with no such limit so that any limit can be set when defining the
waveband. We do so because in some cases it is of interest to vary this limit
in sensitivity analyses.
The effect on the RAF and doses of changing this boundary is substantial, and
has been analysed by Micheletti et al. [3].
}
\examples{
GEN_G_q_fun(293:400)

}
\references{
[1] Caldwell, M. M. (1971) Solar UV irradiation and the growth and development
of higher plants. In Giese, A. C. (Ed.) Photophysiology, Academic Press,
1971, 6, 131-177

[2] Green, A. E. S.; Sawada, T. & Shettle, E. P. (1974) The middle
ultraviolet reaching the ground Photochemistry and Photobiology, 1974, 19,
251-259

[3] Micheletti, M. I.; Piacentini, R. D. & Madronich, S. (2003) Sensitivity
of Biologically Active UV Radiation to Stratospheric Ozone Changes: Effects
of Action Spectrum Shape
and Wavelength Range Photochemistry and Photobiology, 78, 456-461
}
\seealso{
Other BSWF functions: \code{\link{CH4_e_fun}},
  \code{\link{CH4_q_fun}}, \code{\link{CIE_e_fun}},
  \code{\link{CIE_q_fun}}, \code{\link{DNA_GM_q_fun}},
  \code{\link{DNA_P_q_fun}}, \code{\link{FLAV_q_fun}},
  \code{\link{GEN_M_q_fun}}, \code{\link{GEN_T_q_fun}},
  \code{\link{ICNIRP_e_fun}}, \code{\link{PG_q_fun}}
}
\concept{BSWF functions}
