% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plant-qq-ratios.r
\name{UV_PAR}
\alias{UV_PAR}
\title{Calculate UV:PAR photon ratio from spectral irradiance.}
\usage{
UV_PAR(spct, std = "ISO", use.cached.mult = FALSE, use.hinges = TRUE)
}
\arguments{
\item{spct}{an object of class "source.spct"}

\item{std}{select which definition of UV should be used,
defaults to "ISO"}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls}

\item{use.hinges}{logical indicating whether to use hinges to reduce
interpolation errors}
}
\value{
a single numeric nondimensional value giving the UV:PAR photon ratio,
  with name attribute set to the name of the wavebands, with "(q:q)"
  appended.
}
\description{
This function returns the UV:PAR photon ratio of a light source
spectrum.
}
\examples{
UV_PAR(sun.spct)

}
\seealso{
\code{link[photobiologyWavebands]{UV}},
  \code{link[photobiologyWavebands]{PAR}}.
}
