% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.range.arg.r
\name{normalize_range_arg}
\alias{normalize_range_arg}
\title{Normalize a range argument into a true numeric range}
\usage{
normalize_range_arg(range, default.range = c(0, Inf))
}
\arguments{
\item{range}{a numeric vector of length two, or any other object for which
function range() will return two}

\item{default.range}{a numeric vector of length two, missing values are
not allowed, but Inf amd -Inf are.}
}
\value{
a numeric vector of length two, guaranteed not to have missing
  values.
}
\description{
Several functions in this package and the suite accept a range argument
with a flexible syntax. To ensure that all functions and methods behave
in the same way this code has been factored out into a separate function.
}
\details{
The \code{range} argument can contain NAs which are replaced by
  the value at the same position in \code{default.range}. In addition
  a NULL argument for \code{range} is converted into \code{default.range}.
  The \code{default.range} is also the limit to which the returned value
  is trimmed. The idea is that the value supplied as default is the whole
  valid range, and as we use range only for wavelength, the default is
  0 to Inf.
}
\examples{
normalize_range_arg(sun.spct)
normalize_range_arg(c(NA, 500))
normalize_range_arg(c(NA, 500), c(100, Inf))
normalize_range_arg(c(-100, 500), c(-Inf, Inf))

}

