% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.methods.R, R/spct.ratios.R
\name{e_ratio.source_mspct}
\alias{e_ratio}
\alias{e_ratio.default}
\alias{e_ratio.source_mspct}
\alias{e_ratio.source_spct}
\title{Energy:energy ratio}
\usage{
\method{e_ratio}{source_mspct}(spct, w.band.num = NULL, w.band.denom = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.cached.mult = getOption("photobiology.use.cached.mult", default =
  FALSE), use.hinges = getOption("photobiology.use.hinges", default = NULL),
  ..., idx = !is.null(names(spct)))

e_ratio(spct, w.band.num, w.band.denom, wb.trim, use.cached.mult, use.hinges,
  ...)

\method{e_ratio}{default}(spct, w.band.num, w.band.denom, wb.trim,
  use.cached.mult, use.hinges, ...)

\method{e_ratio}{source_spct}(spct, w.band.num = NULL, w.band.denom = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.cached.mult = getOption("photobiology.use.cached.mult", default =
  FALSE), use.hinges = getOption("photobiology.use.hinges", default = NULL),
  ...)
}
\arguments{
\item{spct}{asource_spct}

\item{w.band.num}{waveband or list of waveband objects}

\item{w.band.denom}{waveband or list of waveband objects}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded}

\item{use.cached.mult}{logical Flag telling whether multiplier values should be
cached between calls}

\item{use.hinges}{logical Flag telling whether to use hinges to reduce
interpolation errors}

\item{...}{other arguments (possibly ignored)}

\item{idx}{logical whether to add a column with the names of the elements of spct}
}
\value{
A single numeric nondimensional value giving an energy ratio between
  pairs of wavebands, with name attribute set to the name of each waveband
  unless a named list of wavebands is supplied in which case the names of the
  list elements are used, with "(e:e)" appended.
}
\description{
This function returns the photon ratio for a given pair of wavebands of a
light source spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{source_mspct}: Calculates energy:energy ratio from a \code{source_mspct}
object.

\item \code{default}: Default for generic function

\item \code{source_spct}: Method for \code{source_spct} objects
}}
\note{
Recycling for wavebans takes place when the number of denominator and
  denominator wavebands differ. The last two parameters control speed
  optimizations. The defaults should be suitable in mosts cases. If you will
  use repeatedly the same SWFs on many spectra measured at exactly the same
  wavelengths you may obtain some speed up by setting
  \code{use.cached.mult=TRUE}. However, be aware that you are responsible for
  ensuring that the wavelengths are the same in each call, as the only test
  done is for the length of the \code{w.length} vector.
}
\examples{
e_ratio(sun.spct, new_waveband(400,500), new_waveband(400,700))

}
\seealso{
Other photon and energy ratio functions: \code{\link{energy_ratio}},
  \code{\link{eq_ratio.source_mspct}},
  \code{\link{photon_ratio}},
  \code{\link{photons_energy_ratio}},
  \code{\link{q_ratio.source_mspct}},
  \code{\link{qe_ratio.source_mspct}}
}

