% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.sum.r
\name{s_sum}
\alias{s_sum}
\alias{s_sum.default}
\alias{s_sum.filter_mspct}
\alias{s_sum.source_mspct}
\alias{s_sum.response_mspct}
\alias{s_sum.reflector_mspct}
\alias{s_sum.calibration_mspct}
\title{Sum from collection of spectra}
\usage{
s_sum(x, na.rm, ...)

\method{s_sum}{default}(x, na.rm = FALSE, ...)

\method{s_sum}{filter_mspct}(x, na.rm = FALSE, ...)

\method{s_sum}{source_mspct}(x, na.rm = FALSE, ...)

\method{s_sum}{response_mspct}(x, na.rm = FALSE, ...)

\method{s_sum}{reflector_mspct}(x, na.rm = FALSE, ...)

\method{s_sum}{calibration_mspct}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An R object. Currently this package defines methods for collections of
spectral objects.}

\item{na.rm}{logical. A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  "filter_mspct" object, the returned object is of same class as the
  members of the collection, such as "filter_spct", containing the sum
  of the spectra.
}
\description{
A method to compute the sum of values across members of a collections of
spectra. Computes the sum at each wavelength across all the spectra in the
collection returning a spectral object.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: 

\item \code{filter_mspct}: 

\item \code{source_mspct}: 

\item \code{response_mspct}: 

\item \code{reflector_mspct}: 

\item \code{calibration_mspct}: 
}}

\note{
Omission of NAs is done separately at each wavelength. Interpolation is
  not applied, so all spectra in \code{x} must share the same set of
  wavelengths.

A sum of transmitances or reflectances is no longer a well defined
physical quanttiy, and these sum operations return an object of class
generic_spct.
}
\seealso{
See \code{\link[base]{sum}} for the \code{sum()} method used for
  the computations.
}
