% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.compare.r
\name{compare_spct}
\alias{compare_spct}
\title{Coarse-grained comparison of two spectra}
\usage{
compare_spct(
  x,
  w.band = 10,
  .summary.fun = NULL,
  ...,
  .comparison.fun = `/`,
  returned.value = "spectrum",
  use.hinges = FALSE,
  short.names = TRUE
)
}
\arguments{
\item{x}{A collection of two spectral objects of the same type.}

\item{w.band}{waveband object or a numeric stepsize in nanometres.}

\item{.summary.fun}{function. The summary function to use.}

\item{...}{additional named arguments passed down to \code{.summary.fun}.}

\item{.comparison.fun}{function. The comparison function to use.}

\item{returned.value}{character One of "data.frame", "spectrum", "tagged
spectrum".}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
returned spectrum when tagging it.}

\item{short.names}{logical Flag indicating whether to use short or long names
for wavebands when tagging.}
}
\value{
A \code{generic_spct}, tagged or not with the wavebdans, or a
  \code{data.frame} object containing the summary values per waveband for
  each spectrum and the result of applying the comparison function to these
  summaries.
}
\description{
Compare two spectra using a specified summary function pre-applied to
wavelength intervals.
}
\details{
Summaries are computed for each of the wavebands in \code{w.band} by
  applying function \code{.summary.fun} separately to each spectrum, after
  trimming them to the overlapping wavelength region. Next the matching
  summaries are compared by means of \code{.comparison.fun}. Both the
  summaries and the result of the comparison are returned. Columns containing
  summary values are named by concatenating the name each member spectrum
  with the name of the argument passed to \code{.summary.fun}.

  Tagging is useful for plotting using wavelength based colours, or when
  names for wavebands are used as annotations. When tagging is requested, the
  spectrum is passed to method \code{\link{tag}} with \code{use.hinges} and
  \code{short.names} as additional arguments.
}
\examples{

compare_spct(source_mspct(list(sun1 = sun.spct, sun2 = sun.spct * 2)))
compare_spct(source_mspct(list(sun1 = sun.spct, sun2 = sun.spct * 2)),
             w.band = NULL)
compare_spct(source_mspct(list(sun1 = sun.spct, sun2 = sun.spct * 2)),
             w.band = list(waveband(c(640, 650)), waveband(c(720, 740))))

compare_spct(filter_mspct(list(pet = polyester.spct,
                               yllw = yellow_gel.spct)),
             w.band = 50,
             .comparison.fun = `<`)

head(
  compare_spct(source_mspct(list(sun1 = sun.spct, sun2 = sun.spct * 2)),
               returned.value = "data.frame")
)
compare_spct(source_mspct(list(sun1 = sun.spct, sun2 = sun.spct * 2)),
             returned.value = "tagged spectrum")
compare_spct(source_mspct(list(sun1 = sun.spct, sun2 = sun.spct * 2)),
             returned.value = "tagged spectrum",
             use.hinges = TRUE)

}
