% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.ratios.R
\name{q_ratio}
\alias{q_ratio}
\alias{q_ratio.default}
\alias{q_ratio.source_spct}
\alias{q_ratio.source_mspct}
\title{Photon:photon ratio}
\usage{
q_ratio(spct, w.band.num, w.band.denom, wb.trim, use.cached.mult,
  use.hinges, ...)

\method{q_ratio}{default}(spct, w.band.num, w.band.denom, wb.trim,
  use.cached.mult, use.hinges, ...)

\method{q_ratio}{source_spct}(spct, w.band.num = NULL,
  w.band.denom = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges"), ...)

\method{q_ratio}{source_mspct}(spct, w.band.num = NULL,
  w.band.denom = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.cached.mult = FALSE,
  use.hinges = getOption("photobiology.use.hinges"), ...,
  attr2tb = NULL, idx = "spct.idx", .parallel = FALSE,
  .paropts = NULL)
}
\arguments{
\item{spct}{an object of class "source_spct".}

\item{w.band.num}{waveband object or a list of waveband objects used to
compute the numerator(s) of the ratio(s).}

\item{w.band.denom}{waveband object or a list of waveband objects used to
compute the denominator(s) of the ratio(s).}

\item{wb.trim}{logical if TRUE wavebands crossing spectral data boundaries
are trimmed, if FALSE, they are discarded}

\item{use.cached.mult}{logical indicating whether multiplier values should be
cached between calls}

\item{use.hinges}{logical Flag indicating whether to insert "hinges" into the
spectral data before integration so as to reduce interpolation errors at
the boundaries of the wavebands.}

\item{...}{other arguments (possibly ignored)}

\item{attr2tb}{character vector, see \code{\link{add_attr2tb}} for the syntax for \code{attr2tb} passed as is to formal parameter \code{col.names}.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
In the case of methods for individual spectra, a \code{numeric}
  vector of adimensional values giving a photon ratio between integrated
  photon irradiances for pairs of wavebands, with name attribute set to
  the name of the wavebands unless a named list of wavebands is supplied in
  which case the names of the list elements are used, with "(q:q)" appended.
  A \code{data.frame} in the case of collections of spectra, containing one
  column for each ratio definition, an index column with the names of the
  spectra, and optionally additional columns with metadata values retrieved
  from the attributes of the member spectra.

  Ratio definitions are "assembled" from the arguments passed to
  \code{w.band.num} and \code{w.band.denom}. If both arguments are of equal
  length, then the wavebands are paired to obtain as many ratios as the
  number of wavebands in each list. Recycling for wavebands takes place when
  the number of denominator and numerator wavebands differ.
}
\description{
This function returns the photon ratio for a given pair of wavebands of a
light source spectrum.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{source_spct}: Method for \code{source_spct} objects

\item \code{source_mspct}: Calculates photon:photon from a \code{source_mspct}
object.
}}

\note{
The last two parameters control speed
  optimizations. The defaults should be suitable in most cases. If you will
  use repeatedly the same SWFs on many spectra measured at exactly the same
  wavelengths you may obtain some speed up by setting
  \code{use.cached.mult=TRUE}. However, be aware that you are responsible for
  ensuring that the wavelengths are the same in each call, as the only test
  done is for the length of the \code{w.length} vector.
}
\examples{
q_ratio(sun.spct, new_waveband(400,500), new_waveband(400,700))

}
\seealso{
Other photon and energy ratio functions: \code{\link{e_ratio}},
  \code{\link{eq_ratio}}, \code{\link{qe_ratio}}
}
\concept{photon and energy ratio functions}
