% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{is_photon_based}
\alias{is_photon_based}
\alias{is_energy_based}
\title{Query if a spectrum contains photon- or energy-based data.}
\usage{
is_photon_based(x)

is_energy_based(x)
}
\arguments{
\item{x}{any R object}
}
\value{
\code{is_photon_based} returns \code{TRUE} if its argument is a
  \code{source_spct} or a \code{response_spct} object that contains photon
  base data and \code{FALSE} if such an object does not contain such data,
  but returns \code{NA} for any other R object, including those belonging
  other \code{generic_spct}-derived classes.

\code{is_energy_based} returns \code{TRUE} if its argument is a \code{source_spct} or
a \code{response_spct} object that contains energy base data and \code{FALSE} if such an
object does not contain such data, but returns \code{NA} for any other R object,
including those belonging other \code{generic_spct}-derived classes
}
\description{
Functions to check if \code{source_spct} and \code{response_spct} objects
contains photon-based or energy-based data.
}
\examples{
is_photon_based(sun.spct)
my.spct <- dplyr::select(sun.spct, w.length, s.e.irrad)
is.source_spct(my.spct)
is_photon_based(my.spct)

is_energy_based(sun.spct)
my.spct <- dplyr::select(sun.spct, w.length, s.q.irrad)
is.source_spct(my.spct)
is_energy_based(my.spct)

}
\seealso{
Other query units functions: \code{\link{is_absorbance_based}}
}
