% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.spectrum.r
\name{check_spectrum}
\alias{check_spectrum}
\title{Sanity check of a spectrum.}
\usage{
check_spectrum(w.length, s.irrad)
}
\arguments{
\item{w.length}{numeric Vector of wavelengths (nm)}

\item{s.irrad}{numeric Corresponding vector of spectral (energy) irradiances
(W m-2 nm-1)}
}
\value{
A single \code{logical} value indicating whether test was passed or
  not
}
\description{
This function checks a spectral radiation data in \code{numeric} vectors for
compliance with assumptions used in calculations.
}
\examples{
with(sun.data, check_spectrum(w.length, s.e.irrad))

}
\seealso{
Other data validity check functions: \code{\link{check_spct}},
  \code{\link{check_w.length}}
}

