% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.integrate.r
\name{interpolate_spct}
\alias{interpolate_spct}
\alias{interpolate_mspct}
\title{Map a spectrum to new wavelength values.}
\usage{
interpolate_spct(spct, w.length.out = NULL, fill = NA, length.out = NULL)

interpolate_mspct(
  mspct,
  w.length.out = NULL,
  fill = NA,
  length.out = NULL,
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{spct}{generic_spct}

\item{w.length.out}{numeric vector of wavelengths (nm)}

\item{fill}{a value to be assigned to out of range wavelengths}

\item{length.out}{numeric value}

\item{mspct}{an object of class "generic_mspct"}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A new spectral object of the same class as argument \code{spct} with
  a different number of rows than \code{x}, different \code{w.length} values
  and new numeric values for spectral data obtained by interpolation.
}
\description{
This function gives the result of interpolating spectral data from the original set of
wavelengths to a new one.
}
\details{
Depending on the extent of the data natural spline interpolation or
  linear interpolation are used. In the first case a call to
  \code{\link[stats:splinefun]{spline}} with \code{method = "natural"} is
  used when 25 or fewer distinct wavelengths are available as input, or if
  the wavelengths in the output are more than three times those in the input.
  In the second case, a call to \code{\link[stats:approxfun]{approx}} is
  used.

  If \code{w.length.out} is a numeric vector and \code{length.out = NULL}, it
  directly gives the target wavelengths for interpolation. If it is
  \code{NULL}, and \code{length.out} is an integer value evenly spaced
  wavelength values covering the same wavelength range as in the input are
  generated. If \code{w.length.out} is a numeric vector and \code{length.out}
  is an integer value, \code{length.out} evenly spaced wavelengths covering
  the wavelength range of \code{w.length.out} are generated.
  \emph{Extrapolation is not supported.}

  With default \code{fill = NA} if the output exceeds the wavelength range of
  the input, extrapolated values are filled with \code{NA} values. With
  \code{fill = NULL} wavelengths outside the wavelength range of input data
  are discarded. A numerical value can be also be provided as fill. While
  \code{interpolate_spectrum} supports interpolation of a single numeric
  vector, \code{interpolate_wl} applies, one at a time, interpolation to all
  numeric columns found in \code{x}.
}
\examples{

interpolate_spct(sun.spct, 400:500, NA)
interpolate_spct(sun.spct, 400:500, NULL)
interpolate_spct(sun.spct, seq(200, 1000, by=0.1), 0)
interpolate_spct(sun.spct, c(400,500), length.out=201)

}
