% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.classes.r
\name{getWhenMeasured}
\alias{getWhenMeasured}
\alias{when_measured}
\alias{getWhenMeasured.default}
\alias{getWhenMeasured.generic_spct}
\alias{getWhenMeasured.summary_generic_spct}
\alias{getWhenMeasured.generic_mspct}
\title{Get the "when.measured" attribute}
\usage{
getWhenMeasured(x, ...)

when_measured(x, ...)

\method{getWhenMeasured}{default}(x, ...)

\method{getWhenMeasured}{generic_spct}(x, ...)

\method{getWhenMeasured}{summary_generic_spct}(x, ...)

\method{getWhenMeasured}{generic_mspct}(x, ..., idx = "spct.idx")
}
\arguments{
\item{x}{a generic_spct object}

\item{...}{Allows use of additional arguments in methods for other classes.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}
}
\value{
POSIXct An object with date and time.
}
\description{
Function to read the "when.measured" attribute of an existing generic_spct
or a generic_mspct.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default

\item \code{generic_spct}: generic_spct

\item \code{summary_generic_spct}: summary_generic_spct

\item \code{generic_mspct}: generic_mspct
}}

\note{
If x is not a \code{generic_spct} or an object of a derived class
  \code{NA} is returned.

The method for collections of spectra returns the
  a tibble with the correct times in TZ = "UTC".
}
\examples{

when_measured(sun.spct)

}
\seealso{
Other measurement metadata functions: 
\code{\link{getFilterProperties}()},
\code{\link{getHowMeasured}()},
\code{\link{getInstrDesc}()},
\code{\link{getInstrSettings}()},
\code{\link{getWhatMeasured}()},
\code{\link{getWhereMeasured}()},
\code{\link{get_attributes}()},
\code{\link{isValidInstrDesc}()},
\code{\link{isValidInstrSettings}()},
\code{\link{select_spct_attributes}()},
\code{\link{setFilterProperties}()},
\code{\link{setHowMeasured}()},
\code{\link{setInstrDesc}()},
\code{\link{setInstrSettings}()},
\code{\link{setWhatMeasured}()},
\code{\link{setWhenMeasured}()},
\code{\link{setWhereMeasured}()},
\code{\link{spct_attr2tb}()},
\code{\link{trimInstrDesc}()},
\code{\link{trimInstrSettings}()}
}
\concept{measurement metadata functions}
