% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.illuminance.r
\name{illuminance}
\alias{illuminance}
\alias{illuminance.default}
\alias{illuminance.source_spct}
\alias{illuminance.source_mspct}
\title{Irradiance}
\usage{
illuminance(spct, std, scale.factor, allow.scaled, ...)

\method{illuminance}{default}(spct, std, scale.factor, allow.scaled, ...)

\method{illuminance}{source_spct}(
  spct,
  std = "CIE2deg",
  scale.factor = 1,
  allow.scaled = FALSE,
  naming = "default",
  ...
)

\method{illuminance}{source_mspct}(
  spct,
  std = "CIE2deg",
  scale.factor = 1,
  allow.scaled = FALSE,
  naming = "default",
  ...,
  attr2tb = NULL,
  idx = "spct.idx",
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{spct}{an R object.}

\item{std}{character The luminous efficiency function to use,
\code{"CIE2deg"} or \code{"CIE10deg"}.}

\item{scale.factor}{numeric vector of length 1, or the character string
\code{exposure}.}

\item{allow.scaled}{logical indicating whether scaled or normalized spectra
as argument to spct are flagged as an error.}

\item{...}{other arguments (possibly ignored)}

\item{naming}{character one of \code{"long"}, \code{"default"},
\code{"short"} or \code{"none"}. Used to select the type of names to assign
to returned value.}

\item{attr2tb}{character vector, see \code{\link{add_attr2tb}} for the syntax
for \code{attr2tb} passed as is to formal parameter \code{col.names}.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach.}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A named \code{numeric} vector of length one in the case of methods
  for individual spectra. A \code{data.frame} in the case of collections of
  spectra, containing one column with illuminance, an index column with the
  names of the spectra, and optionally additional columns with metadata
  values retrieved from the attributes of the member spectra.

  The \code{time.unit} attribute is always second. Units are as follows: if
  time.unit of the argument passed to \code{spct} is second, [W m-2 nm-1] ->
  [lx], otherwise average value [lx] for the period unless
  \code{exposure = TRUE}.
}
\description{
Computes illuminance (lux), or the luminous flux incident on a surface, from
spectral irradiance stored in a \code{source_spct} object.
}
\section{Methods (by class)}{
\itemize{
\item \code{illuminance(default)}: Default for generic function

\item \code{illuminance(source_spct)}: Calculates illuminance from a \code{source_spct}
object.

\item \code{illuminance(source_mspct)}: Calculates illuminance from a \code{source_mspct} object.

}}
\note{
Formal parameter \code{allow.scaled} is used internally for calculation
  of ratios, as rescaling and normalization do not invalidate the calculation
  of ratios within one spectrum.
}
\examples{
illuminance(sun.spct)
illuminance(sun.daily.spct)
illuminance(sun.daily.spct, scale.factor = "exposure")
illuminance(sun.daily.spct, scale.factor = 1e-3)

}
\references{
Stockman, A. (2019) Cone fundamentals and CIE standards.
\emph{Current Opinion in Behavioral Sciences}, 30, 87-93.
\doi{10.1016/j.cobeha.2019.06.005}
}
\concept{illumination functions}
