% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbindspct.r
\name{Subset}
\alias{Subset}
\alias{subset.generic_spct}
\title{Subsetting spectra}
\usage{
\method{subset}{generic_spct}(x, subset, select, drop = FALSE, ...)
}
\arguments{
\item{x}{object to be subsetted.}

\item{subset}{logical expression indicating elements or rows to keep: missing
values are taken as false.}

\item{select}{expression, indicating columns to select from a spectrum.}

\item{drop}{passed on to \code{[} indexing operator.}

\item{...}{further arguments to be passed to or from other methods.}
}
\value{
An object similar to \code{x} containing just the selected rows and
  columns. Depending on the columns remaining after subsetting the class of
  the object will be simplified to the most derived parent class.
}
\description{
Return subsets of spectra stored in class \code{generic_spct} or derived from
it.
}
\note{
This method is copied from \code{base::subset.data.frame()} but ensures
  that all metadata stored in attributes of spectral objects are copied to
  the returned value.
}
\examples{

subset(sun.spct, w.length > 400)

}
