% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.normalize.r
\name{normalize}
\alias{normalize}
\alias{normalise}
\alias{normalize.default}
\alias{normalize.source_spct}
\alias{normalize.response_spct}
\alias{normalize.filter_spct}
\alias{normalize.reflector_spct}
\alias{normalize.solute_spct}
\alias{normalize.raw_spct}
\alias{normalize.cps_spct}
\alias{normalize.generic_spct}
\alias{normalize.source_mspct}
\alias{normalize.response_mspct}
\alias{normalize.filter_mspct}
\alias{normalize.reflector_mspct}
\alias{normalize.raw_mspct}
\alias{normalize.cps_mspct}
\title{Normalize spectral data}
\usage{
normalize(x, ...)

normalise(x, ...)

\method{normalize}{default}(x, ...)

\method{normalize}{source_spct}(
  x,
  ...,
  range = NULL,
  norm = "max",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  keep.scaling = FALSE,
  na.rm = FALSE
)

\method{normalize}{response_spct}(
  x,
  ...,
  range = NULL,
  norm = "max",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  keep.scaling = FALSE,
  na.rm = FALSE
)

\method{normalize}{filter_spct}(
  x,
  ...,
  range = NULL,
  norm = "max",
  qty.out = getOption("photobiology.filter.qty", default = "transmittance"),
  keep.scaling = FALSE,
  na.rm = FALSE
)

\method{normalize}{reflector_spct}(
  x,
  ...,
  range = NULL,
  norm = "max",
  qty.out = NULL,
  keep.scaling = FALSE,
  na.rm = FALSE
)

\method{normalize}{solute_spct}(
  x,
  ...,
  range = NULL,
  norm = "max",
  keep.scaling = FALSE,
  na.rm = FALSE
)

\method{normalize}{raw_spct}(
  x,
  ...,
  range = NULL,
  norm = "max",
  keep.scaling = FALSE,
  na.rm = FALSE
)

\method{normalize}{cps_spct}(
  x,
  ...,
  range = NULL,
  norm = "max",
  keep.scaling = FALSE,
  na.rm = FALSE
)

\method{normalize}{generic_spct}(
  x,
  ...,
  range = NULL,
  norm = "max",
  col.names,
  keep.scaling = FALSE,
  na.rm = FALSE
)

\method{normalize}{source_mspct}(
  x,
  ...,
  range = NULL,
  norm = "max",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  keep.scaling = FALSE,
  na.rm = FALSE,
  .parallel = FALSE,
  .paropts = NULL
)

\method{normalize}{response_mspct}(
  x,
  ...,
  range = NULL,
  norm = "max",
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  na.rm = FALSE,
  .parallel = FALSE,
  .paropts = NULL
)

\method{normalize}{filter_mspct}(
  x,
  ...,
  range = NULL,
  norm = "max",
  qty.out = getOption("photobiology.filter.qty", default = "transmittance"),
  na.rm = FALSE,
  .parallel = FALSE,
  .paropts = NULL
)

\method{normalize}{reflector_mspct}(
  x,
  ...,
  range = x,
  norm = "max",
  qty.out = NULL,
  na.rm = FALSE,
  .parallel = FALSE,
  .paropts = NULL
)

\method{normalize}{raw_mspct}(
  x,
  ...,
  range = x,
  norm = "max",
  na.rm = FALSE,
  .parallel = FALSE,
  .paropts = NULL
)

\method{normalize}{cps_mspct}(
  x,
  ...,
  range = x,
  norm = "max",
  na.rm = FALSE,
  .parallel = FALSE,
  .paropts = NULL
)
}
\arguments{
\item{x}{An R object}

\item{...}{not used in current version}

\item{range}{An R object on which \code{range()} returns a numeric vector of
length 2 with the limits of a range of wavelengths in nm, with min and max
wavelengths (nm) used to set boundaries for search for normalization.}

\item{norm}{numeric Normalization wavelength (nm) or character string "max",
or "min" for normalization at the corresponding wavelength, "update" to
update the normalization after modifying units of expression, quantity
or range but respecting the previously used criterion, or "skip" to force
return of \code{x} unchanged.}

\item{unit.out}{character Allowed values "energy", and "photon",
or its alias "quantum"}

\item{keep.scaling}{logical Flag to indicate if any existing scaling should
be preserved or not. The default, \code{FALSE}, preserves the behaviour
of versions (<= 0.10.9).}

\item{na.rm}{logical indicating whether \code{NA} values should be stripped
before calculating the summary (e.g. "max") used for normalization.}

\item{qty.out}{character string  Allowed values are "transmittance", and
"absorbance" indicating on which quantity to apply the normalization.}

\item{col.names}{character vector containing the names of columns or
variables to which to apply the normalization.}

\item{.parallel}{if TRUE, apply function in parallel, using parallel backend
provided by foreach}

\item{.paropts}{a list of additional options passed into the foreach function
when parallel computation is enabled. This is important if (for example)
your code relies on external data or packages: use the .export and
.packages arguments to supply them so that all cluster nodes have the
correct environment set up for computing.}
}
\value{
A copy of \code{x}, with spectral data values normalized to one for
  the criterion specified by the argument passed to \code{norm} with
  information about the normalization applied saved in attributes
  \code{"normalized"} and \code{"normalization"}.

A copy of \code{x} with the values of the spectral quantity rescaled
  to 1 at the normalization wavelength. If the normalization wavelength is
  not already present in \code{x}, it is added by interpolation---i.e. the
  returned value may be one row longer than \code{x}. Attributes
  \code{normalized} and \code{normalization} are set to keep a log of the
  computations applied.
}
\description{
This method returns a spectral object of the same class as the one
supplied as argument but with the spectral data normalized to 1.0 at a
specific wavelength.
}
\details{
By default normalization is done based on the maximum of the
  spectral data. It is possible to also do the normalization based on a
  user-supplied wavelength expressed in nanometres or the minimum. It is
  also possible to update an existing normalization for different units
  of expression or after a conversion to a related spectral quantity.

  By default the function is applied to the whole spectrum, but by passing a
  range of wavelengths as input, the search can be limited to a region of
  interest within the spectrum.

  In 'photobiology' (>= 0.10.8) detailed information about the normalization
  is stored in an attribute. In 'photobiology' (>= 0.10.10)
  applying a new normalization to an already normalized spectrum recomputes
  the multiplier factors stored in the attributes whenever possible. This
  ensures that the returned object is identical independently of the previous
  application of a different normalization.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default for generic function

\item \code{source_spct}: Normalize a \code{source_spct} object.

\item \code{response_spct}: Normalize a response spectrum.

\item \code{filter_spct}: Normalize a filter spectrum.

\item \code{reflector_spct}: Normalize a reflector spectrum.

\item \code{solute_spct}: Normalize a solute spectrum.

\item \code{raw_spct}: Normalize a raw spectrum.

\item \code{cps_spct}: Normalize a cps spectrum.

\item \code{generic_spct}: Normalize a raw spectrum.

\item \code{source_mspct}: Normalize the members of a source_mspct object.

\item \code{response_mspct}: Normalize the members of a response_mspct object.

\item \code{filter_mspct}: Normalize the members of a filter_mspct object.

\item \code{reflector_mspct}: Normalize the members of a reflector_mspct object.

\item \code{raw_mspct}: Normalize the members of a raw_mspct object.

\item \code{cps_mspct}: Normalize the members of a cps_mspct object.
}}

\note{
If the spectrum passed as argument to \code{x} has been previously
  scaled, in 'photobiology' (<= 0.10.9) the scaling attribute was always
  removed and no normalization factors returned. In 'photobiology'
  (>= 0.10.10) scaling information can be preserved by passing
  \code{keep.scaling = TRUE} (experimental feature).

\code{normalise()} is a synonym for this \code{normalize()} method.

1) By default if \code{x} contains one or more \code{NA} values and the
  normalization is based on a summary quantity, the returned spectrum will
  contain only \code{NA} values. If \code{na.rm == TRUE} then the summary
  quantity will be calculated after striping \code{NA} values, and only the
  values that were \code{NA} in \code{x} will be {NA} values in the returned
  spectrum.
}
\examples{

normalize(sun.spct)
normalise(sun.spct) # equivalent

normalize(sun.spct, norm = "max")
normalize(sun.spct, norm = 400)

}
\seealso{
Other rescaling functions: 
\code{\link{fscale}()},
\code{\link{fshift}()},
\code{\link{getNormalized}()},
\code{\link{getScaled}()},
\code{\link{is_normalized}()},
\code{\link{is_scaled}()},
\code{\link{setNormalized}()},
\code{\link{setScaled}()}
}
\concept{rescaling functions}
