% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phoenix_cardiovascular.R
\name{phoenix_cardiovascular}
\alias{phoenix_cardiovascular}
\title{Phoenix Cardiovascular Score}
\usage{
phoenix_cardiovascular(
  vasoactives = NA_integer_,
  lactate = NA_real_,
  age = NA_real_,
  map = NA_real_,
  data = parent.frame(),
  ...
)
}
\arguments{
\item{vasoactives}{an integer vector, the number of systemic vasoactive medications being administered to the patient.  Six vasoactive medications are considered: dobutamine, dopamine, epinephrine, milrinone, norepinephrine, vasopressin.}

\item{lactate}{numeric vector with the lactate value in mmol/L}

\item{age}{numeric vector age in months}

\item{map}{numeric vector, mean arterial pressure in mmHg}

\item{data}{a \code{list}, \code{data.frame}, or \code{environment} containing the input vectors}

\item{...}{pass through}
}
\value{
a integer vector with values 0, 1, 2, 3, 4, 5, or 6.

As with all other Phoenix organ system scores, missing values in the data
set will map to a score of zero - this is consistent with the development of
the criteria.
}
\description{
Generate the cardiovascular organ system dysfunction score as part of the
diagnostic Phoenix Sepsis Criteria.
}
\details{
There where six systemic vasoactive medications considered when the Phoenix
criteria was developed: dobutamine, dopamine, epinephrine, milrinone,
norepinephrine, and vasopressin.

During development, the values used for \code{map} were taken preferentially
from arterial measurement, then cuff measures, and provided values before
approximating the map from blood pressure values via DBP + 1/3 (SBP - DBP),
where DBP is the diastolic blood pressure and SBP is the systolic blood
pressure.
}
\section{Phoenix Cardiovascular Scoring}{

The Phoenix Cardiovascular score ranges from 0 to 6 points; 0, 1, or 2 points
for each of systolic vasoactive medications, lactate, and MAP.

\emph{Systemic Vasoactive Medications}
\tabular{ll}{
  0 medications \tab 0 points \cr
  1 medication  \tab 1 point  \cr
  2 or more medications \tab 2 points
}

 \emph{Lactate}
 \tabular{ll}{
    [0, 5) \tab 0 points \cr
    [5, 11) \tab 1 point  \cr
    [11, Inf) \tab 2 points
 }

 \emph{MAP}
 \tabular{lll}{
   Age in [0, 1) months  \tab \tab \cr
     \tab [31, Inf) mmHg \tab 0 points \cr
     \tab [17, 31)  mmHg \tab 1 point  \cr
     \tab [0, 17)   mmHg \tab 2 points \cr
   Age in [1, 12) months \tab \tab \cr
     \tab [39, Inf) mmHg \tab 0 points \cr
     \tab [25, 39)  mmHg \tab 1 point  \cr
     \tab [0, 25)   mmHg \tab 2 points \cr
   Age in [12, 24) months \tab\tab \cr
     \tab [44, Inf) mmHg \tab 0 points \cr
     \tab [31, 44)  mmHg \tab 1 point  \cr
     \tab [0, 31)   mmHg \tab 2 points \cr
   Age in [24, 60) months \tab\tab \cr
     \tab [45, Inf) mmHg \tab 0 points \cr
     \tab [32, 45)  mmHg \tab 1 point  \cr
     \tab [0, 32)   mmHg \tab 2 points \cr
   Age in [60, 144) months \tab\tab \cr
     \tab [49, Inf) mmHg \tab 0 points \cr
     \tab [36, 49)  mmHg \tab 1 point  \cr
     \tab [0, 36)   mmHg \tab 2 points \cr
   Age in [144, 216] months \tab\tab \cr
     \tab [52, Inf) mmHg \tab 0 points \cr
     \tab [38, 52)  mmHg \tab 1 point  \cr
     \tab [0, 38)   mmHg \tab 2 points \cr
 }
}

\examples{

# using the example sepsis data set
phoenix_cardiovascular(
   vasoactives = dobutamine + dopamine + epinephrine + milrinone + norepinephrine + vasopressin,
   lactate = lactate,
   age = age,
   map = dbp + (sbp - dbp)/3,
   data = sepsis
)

# example data set to get all the possible scores
DF <-
  expand.grid(vasos = c(NA, 0:6),
              lactate = c(NA, 3.2, 5, 7.8, 11, 14),
              age = c(NA, 0.4, 1, 3, 12, 18, 24, 45, 60, 61, 144, 145),
              map = c(NA, 16:52))
DF$card <- phoenix_cardiovascular(vasos, lactate, age, map, DF)
head(DF)

# what if lactate is unknown for all records? - set the value either in the
# data object or the arguement value to NA
DF2 <-
  expand.grid(vasos = c(NA, 0:6),
              age = c(NA, 0.4, 1, 3, 12, 18, 24, 45, 60, 61, 144, 145),
              map = c(NA, 16:52))
DF2$card <- phoenix_cardiovascular(vasos, lactate = NA, age, map, DF2)

DF3 <-
  expand.grid(vasos = c(NA, 0:6),
              lactate = NA,
              age = c(NA, 0.4, 1, 3, 12, 18, 24, 45, 60, 61, 144, 145),
              map = c(NA, 16:52))
DF3$card <- phoenix_cardiovascular(vasos, lactate, age, map, DF3)

identical(DF2$card, DF3$card)



}
\references{
See reference details in \code{\link{phoenix-package}} or by calling
\code{citation('phoenix')}.
}
\seealso{
\itemize{
  \item \code{\link{phoenix}} for generating the diagnostic Phoenix
    Sepsis score based on the four organ systems:
    \itemize{
      \item \code{\link{phoenix_cardiovascular}},
      \item \code{\link{phoenix_coagulation}},
      \item \code{\link{phoenix_neurologic}},
      \item \code{\link{phoenix_respiratory}},
    }
  \item \code{\link{phoenix8}} for generating the diagnostic Phoenix 8
    Sepsis criteria based on the four organ systems noted above and
    \itemize{
      \item \code{\link{phoenix_endocrine}},
      \item \code{\link{phoenix_immunologic}},
      \item \code{\link{phoenix_renal}},
      \item \code{\link{phoenix_hepatic}},
    }
}

\code{vignette('phoenix')} for more details and examples.
}
