% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathwayRes-class.R
\name{pathwayRes}
\alias{pathwayRes}
\alias{summary.pathwayRes}
\alias{print.pathwayRes}
\alias{plot.pathwayRes}
\alias{head}
\alias{head.pathwayRes}
\alias{extract}
\alias{extract.pathwayRes}
\alias{adjust_pval}
\alias{adjust_pval.pathwayRes}
\title{Class pathwayRes}
\usage{
\method{summary}{pathwayRes}(object, ...)

\method{print}{pathwayRes}(x, ...)

\method{plot}{pathwayRes}(
  x,
  ...,
  pathway_id = NULL,
  plot = c("eig", "var", "ind"),
  habillage = "none"
)

head(object)

extract(object, pathway_id)

adjust_pval(object, method = p.adjust.methods, n = length(object))
}
\arguments{
\item{object, x}{object of class \code{pathwayRes}}

\item{...}{not used}

\item{pathway_id}{a character string or vector of pathway codes or names}

\item{plot}{a character string indicating the type of plot to return. Default
to \code{"eig"} (the screegraph of the PCA is displayed)}

\item{habillage}{a character string indicating the column of the design used 
to color the individuals. Only used when \code{plot = "ind"}. Default to 
\code{"none"} (no color)}

\item{method}{a character string indicating the correction method to be used
for multiple testing correction (authorized values are those of 
\code{\link{p.adjust.methods}})}

\item{n}{number of comparisons for multiple testing correction}
}
\value{
The function \code{extract} returns an object of class
\code{pathwayRes} which is a list of pathway results, containing only the
pathways in \code{pathway_id}.

The function \code{adjust_pval} returns a data.frame with pathways
in rows and the following information in columns:
\item{pathway_name}{name of the pathway}
\item{pathway_code}{pathway code (identifier)}
\item{Fixed_effect}{tested effect}
\item{pval}{raw p-value of the pathway}
\item{adjusted_pval}{adjusted p-value of the pathway}
}
\description{
S3 class for pathway differential analysis results
}
\details{
Methods for the class pathwayRes
}
\examples{
data("MTBLS422")
quantif <- from_ASICS_to_PHOENICS(quantif)
out_test <- test_pathway(quantif, design, pathways, 
                         fixed = c("Age", "Treatment"), random = "Mouse", 
                         npc = 2, model = "blmer")
summary(out_test)
print(out_test)
plot(out_test)
plot(out_test, "mmu00052", plot = "var")
plot(out_test, "mmu00052", plot = "ind", habillage = "Age")
head(out_test)
extract(out_test, "mmu00562")
adj_pval <- adjust_pval(out_test)
}
