% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_MODIS.R
\name{tidy_MOD13}
\alias{tidy_MOD13}
\title{tidy_MOD13}
\usage{
tidy_MOD13(infile, outfile, wmin = 0.2)
}
\arguments{
\item{infile}{A character csv file path or a data.table}

\item{outfile}{Output file name. If missing, will not be written to file.}

\item{wmin}{Double, minimum weight of bad points, which could be smaller
the weight of snow, ice and cloud.}
}
\value{
A tidied data.table, with columns of 'site', 'y', 't', 'w', 'date' and
'SummaryQA'.
\itemize{
\item \code{site}: site name
\item \code{y}: real value of EVI, \verb{[-1, 1]}
\item \code{date}: image date
\item \code{t}: exact compositing date constructed from \code{DayOfYear}
\item \code{w}: weights
\item \code{SummaryQA}: A factor, QA types, one of "good", "margin", "snow/ice"
or "cloud".
}
}
\description{
Tidy MODIS 'MOD13' VI products' (e.g. MOD13A1, MOD13A2, ...) raw data exported from
Google Earth Engine.
Tidy contents include: \cr
\enumerate{
\item add exact compositing date, see \code{\link[=getRealDate]{getRealDate()}}. \cr
\item Init weigths according \code{SummaryQA}, see \code{\link[=qc_summary]{qc_summary()}}. \cr
}
}
\examples{
library(phenofit)
data("MOD13A1")
dt <- tidy_MOD13(MOD13A1$dt)
}
\keyword{internal}
