% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{calculate_bic}
\alias{calculate_bic}
\title{calculate_bic}
\usage{
calculate_bic(model, likelihood, type = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model object}

\item{likelihood}{(numeric) -2LL to use}

\item{type}{(str (optional)) Type of BIC to calculate. Default is the mixed effects.}
}
\value{
(numeric) BIC of model fit
}
\description{
Calculate BIC

Different variations of the BIC can be calculated:
\itemize{
\item | mixed (default)
| BIC = -2LL + n_random_parameters * log(n_individuals) +
|       n_fixed_parameters * log(n_observations)
\item | fixed
| BIC = -2LL + n_estimated_parameters * log(n_observations)
\item | random
| BIC = -2LL + n_estimated_parameters * log(n_individals)
\item | iiv
| BIC = -2LL + n_estimated_iiv_omega_parameters * log(n_individals)
}
}
\examples{
\dontrun{
model <- load_example_model("pheno")
results <- load_example_modelfit_results("pheno")
ofv <- results$ofv
calculate_bic(model, ofv)
calculate_bic(model, ofv, type='fixed')
calculate_bic(model, ofv, type='random')
calculate_bic(model, ofv, type='iiv')
}

}
