% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{run_covsearch}
\alias{run_covsearch}
\title{run_covsearch}
\usage{
run_covsearch(
  effects,
  p_forward = 0.05,
  max_steps = -1,
  algorithm = "scm-forward",
  model = NULL
)
}
\arguments{
\item{effects}{(str | vector) The vector of candidates to try, either in DSL str form or in
(optionally compact) tuple form.}

\item{p_forward}{(numeric) The p-value to use in the likelihood ratio test for forward steps}

\item{max_steps}{(integer) The maximum number of search steps to make}

\item{algorithm}{(str) The search algorithm to use. Currently only 'scm-forward' is supported.}

\item{model}{(Model) Pharmpy model}
}
\value{
(COVSearchResults) COVsearch tool result object
}
\description{
Run COVsearch tool. For more details, see :ref:\code{covsearch}.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
res <- run_covsearch([
}

}
