% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{resample_data}
\alias{resample_data}
\title{resample_data}
\usage{
resample_data(
  dataset_or_model,
  group,
  resamples = 1,
  stratify = NULL,
  sample_size = NULL,
  replace = FALSE,
  name_pattern = "resample_{}",
  name = NULL
)
}
\arguments{
\item{dataset_or_model}{(data.frame or Model) Dataset or Model to use}

\item{group}{(str) Name of column to group by}

\item{resamples}{(integer) Number of resamples (iterations) to make}

\item{stratify}{(str) Name of column to use for stratification.
The values in the stratification column must be equal within a group so that the group
can be uniquely determined. A ValueError exception will be raised otherwise.}

\item{sample_size}{(integer) The number of groups that should be sampled. The default is
the number of groups. If using stratification the default is to sample using the
proportion of the stratas in the dataset. A list of specific sample sizes
for each strata can also be supplied.}

\item{replace}{(logical) A boolean controlling whether sampling should be done with or
without replacement}

\item{name_pattern}{(str) Name to use for generated datasets. A number starting from 1 will
be put in the placeholder.}

\item{name}{(str) Option to name pattern in case of only one resample}
}
\value{
(iterator) An iterator yielding tuples of a resampled DataFrame and a vector of resampled groups in order
}
\description{
Iterate over resamples of a dataset.

The dataset will be grouped on the group column then groups will be selected
randomly with or without replacement to form a new dataset.
The groups will be renumbered from 1 and upwards to keep them separated in the new
dataset.
}
