% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{check_high_correlations}
\alias{check_high_correlations}
\title{check_high_correlations}
\usage{
check_high_correlations(model, limit = 0.9)
}
\arguments{
\item{model}{(Model) Pharmpy model object}

\item{limit}{(numeric) Lower limit for a high correlation}
}
\value{
(data.frame) Correlation values indexed on pairs of parameters for (absolute) correlations above limit
}
\description{
Check for highly correlated parameter estimates
}
\examples{
\dontrun{
model <- load_example_model("pheno")
check_high_correlations(model, limit=0.3)
}

}
