% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{calculate_inf_from_corrse}
\alias{calculate_inf_from_corrse}
\title{calculate_inf_from_corrse}
\usage{
calculate_inf_from_corrse(corr, se)
}
\arguments{
\item{corr}{(data.frame) Correlation matrix}

\item{se}{(data.frame) Standard errors}
}
\value{
(data.frame) Information matrix
}
\description{
Calculate information matrix from a correlation matrix and standard errors
}
\examples{
\dontrun{
model <- load_example_model("pheno")
corr <- model$modelfit_results$correlation_matrix
se <- model$modelfit_results$standard_errors
corr
calculate_inf_from_corrse(corr, se)
}
}
\seealso{
calculate_se_from_cov : Standard errors from covariance matrix

calculate_se_from_inf : Standard errors from information matrix

calculate_corr_from_cov : Correlation matrix from covariance matrix

calculate_cov_from_inf : Covariance matrix from information matrix

calculate_cov_from_corrse : Covariance matrix from correlation matrix and standard errors

calculate_inf_from_cov : Information matrix from covariance matrix

calculate_corr_from_inf : Correlation matrix from information matrix
}
