/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.filters;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.resources.filters.FilterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunLengthDecode
extends InputStream {
    private InputStream in;
    private static final int EOF_CHAR = -1;
    private static final int IOEXCEPTION_CHAR = -2;
    private static final int EOD_CHAR = -3;
    private ArrayList<Integer> decodedChars;
    private int decodedPtr;
    private int lastMarkPtr = -1;
    private boolean closeSource;

    public RunLengthDecode(InputStream inputStream, PSObjectDict pSObjectDict) throws PSError {
        this.in = inputStream;
        PSObject pSObject = pSObjectDict.lookup(FilterManager.KEY_CLOSESOURCE);
        this.closeSource = pSObject != null ? pSObject.toBool() : false;
    }

    @Override
    public int available() throws IOException {
        if (this.in != null) {
            return this.decodedChars.size() - this.decodedPtr;
        }
        throw new IOException();
    }

    @Override
    public void close() throws IOException {
        if (this.closeSource) {
            this.in.close();
        }
        this.in = null;
    }

    @Override
    public void mark(int n) {
        this.lastMarkPtr = this.decodedPtr;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        int n;
        if (this.in == null) {
            throw new IOException();
        }
        if (this.decodedChars == null) {
            this.decodedChars = RunLengthDecode.readAndDecodeAllChars(this.in);
            this.decodedPtr = 0;
        }
        if ((n = this.decodedChars.get(this.decodedPtr).intValue()) >= 0) {
            ++this.decodedPtr;
            return n;
        }
        if (n == -3 || n == -1) {
            return -1;
        }
        throw new IOException();
    }

    /*
     * Unable to fully structure code
     */
    private static ArrayList<Integer> readAndDecodeAllChars(InputStream var0) {
        var1_1 = new ArrayList<Integer>();
lbl2:
        // 3 sources

        try {
            while ((var2_2 = var0.read()) != -1) {
                block7: {
                    if (var2_2 > 127) break block7;
                    for (var3_3 = 0; var3_3 < var2_2 + 1; ++var3_3) {
                        var1_1.add(var0.read());
                    }
                    ** GOTO lbl2
                }
                if (var2_2 == 128) {
                    var1_1.add(-3);
                    break;
                }
                if (var2_2 > 255) continue;
                var3_3 = var0.read();
                for (var4_5 = 0; var4_5 < 257 - var2_2; ++var4_5) {
                    var1_1.add(var3_3);
                }
                ** GOTO lbl2
            }
        }
        catch (IOException var3_4) {
            var1_1.add(-2);
        }
        var1_1.add(-1);
        return var1_1;
    }

    @Override
    public void reset() throws IOException {
        if (this.lastMarkPtr < 0) {
            throw new IOException();
        }
        this.decodedPtr = this.lastMarkPtr;
    }
}

