/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources.filters;

import java.io.IOException;
import java.io.InputStream;
import net.sf.eps2pgf.ps.errors.PSError;
import net.sf.eps2pgf.ps.errors.PSErrorRangeCheck;
import net.sf.eps2pgf.ps.objects.PSObject;
import net.sf.eps2pgf.ps.objects.PSObjectDict;
import net.sf.eps2pgf.ps.objects.PSObjectName;
import net.sf.eps2pgf.ps.resources.filters.FilterManager;

public class SubFileDecode
extends InputStream {
    public static final PSObjectName KEY_EODCOUNT = new PSObjectName("/EODCount");
    public static final PSObjectName KEY_EODSTRING = new PSObjectName("/EODString");
    private InputStream source;
    private int eodCount;
    private String eodString;
    private boolean closeSource;
    private int eodOccurrences = 0;
    private int[] readBuffer;
    private int bufferPtr = 0;
    private int n;
    private int[] eodStringBuffer;

    public SubFileDecode(InputStream inputStream, PSObjectDict pSObjectDict) throws PSError {
        this.source = inputStream;
        PSObject pSObject = pSObjectDict.lookup(KEY_EODCOUNT);
        if (pSObject != null) {
            this.eodCount = pSObject.toInt();
            if (this.eodCount < 0) {
                throw new PSErrorRangeCheck();
            }
        } else {
            this.eodCount = 1;
        }
        this.eodString = (pSObject = pSObjectDict.lookup(KEY_EODSTRING)) != null ? pSObject.toString() : "%%EndBinary";
        this.n = this.eodString.length();
        this.eodStringBuffer = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.eodStringBuffer[i] = this.eodString.charAt(i);
        }
        pSObject = pSObjectDict.lookup(FilterManager.KEY_CLOSESOURCE);
        this.closeSource = pSObject != null ? pSObject.toBool() : false;
        this.readBuffer = new int[this.n];
        this.blankBuffer();
    }

    public int available() throws IOException {
        if (this.source != null) {
            return this.source.available();
        }
        throw new IOException();
    }

    public void close() throws IOException {
        if (this.closeSource) {
            this.source.close();
        }
        this.source = null;
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.n == 0) {
            return this.readNEqualsZero();
        }
        return this.readNLargerThanZero();
    }

    private int readNEqualsZero() throws IOException {
        if (this.eodOccurrences >= this.eodCount) {
            return -1;
        }
        ++this.eodOccurrences;
        return this.source.read();
    }

    private int readNLargerThanZero() throws IOException {
        int n;
        if (this.readBuffer[0] == -99 && this.eodCount == 0) {
            this.fillBuffer();
        }
        if (this.buffersEqual()) {
            ++this.eodOccurrences;
        }
        if (this.eodCount == 0 && this.eodOccurrences > 0 || this.eodCount > 0 && this.eodOccurrences >= this.eodCount) {
            return -1;
        }
        if (this.eodCount == 0) {
            n = this.readBuffer[this.bufferPtr];
            this.readBuffer[this.bufferPtr] = this.source.read();
        } else {
            this.readBuffer[this.bufferPtr] = n = this.source.read();
        }
        ++this.bufferPtr;
        if (this.bufferPtr >= this.eodString.length()) {
            this.bufferPtr = 0;
        }
        return n;
    }

    private boolean buffersEqual() {
        for (int i = 0; i < this.n; ++i) {
            int n = (i + this.bufferPtr) % this.n;
            if (this.readBuffer[n] == this.eodStringBuffer[i]) continue;
            return false;
        }
        this.blankBuffer();
        return true;
    }

    private void blankBuffer() {
        for (int i = 0; i < this.n; ++i) {
            this.readBuffer[i] = -99;
        }
    }

    private void fillBuffer() {
        for (int i = 0; i < this.n; ++i) {
            try {
                this.readBuffer[i] = this.source.read();
                continue;
            }
            catch (IOException iOException) {
                this.readBuffer[i] = -99;
            }
        }
    }
}

