% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1client_lib.R
\name{model_run}
\alias{model_run}
\title{Executes PRISM model}
\usage{
model_run(
  model_name = NULL,
  model_input = NULL,
  api_key = NULL,
  server = NULL,
  async = FALSE
)
}
\arguments{
\item{model_name}{name of the model}

\item{model_input}{required custom parameters for current model}

\item{api_key}{API key}

\item{server}{server address. Defaults to the Peer Models Network PRSIM repository.}

\item{async}{should the model be called in async mode?}
}
\value{
0 for success and 1 for error
}
\description{
Executes PRISM model
}
\examples{
\dontrun{
sample_input <- get_default_input(model_name = "epic", api_key = "YOUR_API_KEY")
sample_input$global_parameters.time_horizon <- 15
model_run ("epic", model_input = sample_input)
}
}
