# pci

***A Collection of Process Capability Index Functions***

## Installation
```
install.packages("pci")
```

## About
Provides a collection of process capability index functions, such as $C_p$,
$C_{pk}$, $C_{pm}$, and others, along with metadata about each, like LaTeX
equations and R expressions. Its primary purpose is to form a foundation for
other quality control packages to build on top of, by providing basic resources
and functions. The indices belong to the field of statistical quality control,
and quantify the degree to which a manufacturing process is able to create items
that adhere to a certain standard of quality. For details see Montgomery, D. C.
(2019, ISBN:978-1-119-39930-8).

**Included:**

* $C_p$
* $C_{pl}$
* $C_{pu}$
* $C_{pk}$
* $C_{pm}$

## References
* Montgomery, D. C. (2019). *Introduction to statistical quality control* (8th ed.). Wiley. ISBN: 978-1-119-39930-8