% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_features.R
\name{extract_features}
\alias{extract_features}
\title{Extract features for paw time series}
\usage{
extract_features(
  x,
  y = NULL,
  parameters = default_parameters(),
  diagnostics = FALSE
)
}
\arguments{
\item{x}{time series of horizontal paw movement. Alternatively,
a two column matrix of x and y time series, respectively.}

\item{y}{time series of vertical paw movement, or NULL if x is
a two column matrix.}

\item{parameters}{contains information about frames per second,
filtering, windowing, and thresholds, for paw features
(see \code{\link{default_parameters}}, or use
\code{\link{set_parameters}} to modify the defaults).}

\item{diagnostics}{set to TRUE will record intermediate values
used when computing paw features. This information can
be helpful for debugging parameter choices. The default,
FALSE, is to not record these values.}
}
\value{
pre-peak and post-peak paw features (plus diagnostics,
        if enabled)
}
\description{
Extract features for paw time series
}
\examples{
# example usage with a track from Jones et al. (2020)
track    <- jones2020.tracks[[1]]
features <- extract_features(track$time.series)

}
