% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recyclebin_operations.R
\name{recyclebin_update_rule}
\alias{recyclebin_update_rule}
\title{Updates an existing Recycle Bin retention rule}
\usage{
recyclebin_update_rule(
  Identifier,
  RetentionPeriod = NULL,
  Description = NULL,
  ResourceType = NULL,
  ResourceTags = NULL
)
}
\arguments{
\item{Identifier}{[required] The unique ID of the retention rule.}

\item{RetentionPeriod}{Information about the retention period for which the retention rule is
to retain resources.}

\item{Description}{The retention rule description.}

\item{ResourceType}{This parameter is currently not supported. You can't update a retention
rule's resource type after creation.}

\item{ResourceTags}{Specifies the resource tags to use to identify resources that are to be
retained by a tag-level retention rule. For tag-level retention rules,
only deleted resources, of the specified resource type, that have one or
more of the specified tag key and value pairs are retained. If a
resource is deleted, but it does not have any of the specified tag key
and value pairs, it is immediately deleted without being retained by the
retention rule.

You can add the same tag key and value pair to a maximum or five
retention rules.

To create a Region-level retention rule, omit this parameter. A
Region-level retention rule does not have any resource tags specified.
It retains all deleted resources of the specified resource type in the
Region in which the rule is created, even if the resources are not
tagged.}
}
\description{
Updates an existing Recycle Bin retention rule. You can update a retention rule's description, resource tags, and retention period at any time after creation. You can't update a retention rule's resource type after creation. For more information, see \href{https://docs.aws.amazon.com/ebs/latest/userguide/recycle-bin-working-with-rules.html#recycle-bin-update-rule}{Update Recycle Bin retention rules} in the \emph{Amazon Elastic Compute Cloud User Guide}.

See \url{https://www.paws-r-sdk.com/docs/recyclebin_update_rule/} for full documentation.
}
\keyword{internal}
