% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_list_access_grants_locations}
\alias{s3control_list_access_grants_locations}
\title{Returns a list of the locations registered in your S3 Access Grants
instance}
\usage{
s3control_list_access_grants_locations(
  AccountId,
  NextToken = NULL,
  MaxResults = NULL,
  LocationScope = NULL
)
}
\arguments{
\item{AccountId}{[required] The ID of the Amazon Web Services account that is making this request.}

\item{NextToken}{A pagination token to request the next page of results. Pass this value
into a subsequent \verb{List Access Grants Locations} request in order to
retrieve the next page of results.}

\item{MaxResults}{The maximum number of access grants that you would like returned in the
\verb{List Access Grants} response. If the results include the pagination
token \code{NextToken}, make another call using the \code{NextToken} to determine
if there are more results.}

\item{LocationScope}{The S3 path to the location that you are registering. The location scope
can be the default S3 location \verb{s3://}, the S3 path to a bucket
\verb{s3://<bucket>}, or the S3 path to a bucket and prefix
\verb{s3://<bucket>/<prefix>}. A prefix in S3 is a string of characters at
the beginning of an object key name used to organize the objects that
you store in your S3 buckets. For example, object key names that start
with the \verb{engineering/} prefix or object key names that start with the
\verb{marketing/campaigns/} prefix.}
}
\description{
Returns a list of the locations registered in your S3 Access Grants instance.

See \url{https://www.paws-r-sdk.com/docs/s3control_list_access_grants_locations/} for full documentation.
}
\keyword{internal}
