# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include backup_service.R
NULL

#' This action removes the specified legal hold on a recovery point
#'
#' @description
#' This action removes the specified legal hold on a recovery point. This action can only be performed by a user with sufficient permissions.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_cancel_legal_hold/](https://www.paws-r-sdk.com/docs/backup_cancel_legal_hold/) for full documentation.
#'
#' @param LegalHoldId &#91;required&#93; Legal hold ID required to remove the specified legal hold on a recovery
#' point.
#' @param CancelDescription &#91;required&#93; String describing the reason for removing the legal hold.
#' @param RetainRecordInDays The integer amount in days specifying amount of days after this API
#' operation to remove legal hold.
#'
#' @keywords internal
#'
#' @rdname backup_cancel_legal_hold
backup_cancel_legal_hold <- function(LegalHoldId, CancelDescription, RetainRecordInDays = NULL) {
  op <- new_operation(
    name = "CancelLegalHold",
    http_method = "DELETE",
    http_path = "/legal-holds/{legalHoldId}",
    paginator = list()
  )
  input <- .backup$cancel_legal_hold_input(LegalHoldId = LegalHoldId, CancelDescription = CancelDescription, RetainRecordInDays = RetainRecordInDays)
  output <- .backup$cancel_legal_hold_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$cancel_legal_hold <- backup_cancel_legal_hold

#' Creates a backup plan using a backup plan name and backup rules
#'
#' @description
#' Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains information that Backup uses to schedule tasks that create recovery points for resources.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_create_backup_plan/](https://www.paws-r-sdk.com/docs/backup_create_backup_plan/) for full documentation.
#'
#' @param BackupPlan &#91;required&#93; Specifies the body of a backup plan. Includes a `BackupPlanName` and one
#' or more sets of `Rules`.
#' @param BackupPlanTags To help organize your resources, you can assign your own metadata to the
#' resources that you create. Each tag is a key-value pair. The specified
#' tags are assigned to all backups created with this plan.
#' @param CreatorRequestId Identifies the request and allows failed requests to be retried without
#' the risk of running the operation twice. If the request includes a
#' `CreatorRequestId` that matches an existing backup plan, that plan is
#' returned. This parameter is optional.
#' 
#' If used, this parameter must contain 1 to 50 alphanumeric or '-_.'
#' characters.
#'
#' @keywords internal
#'
#' @rdname backup_create_backup_plan
backup_create_backup_plan <- function(BackupPlan, BackupPlanTags = NULL, CreatorRequestId = NULL) {
  op <- new_operation(
    name = "CreateBackupPlan",
    http_method = "PUT",
    http_path = "/backup/plans/",
    paginator = list()
  )
  input <- .backup$create_backup_plan_input(BackupPlan = BackupPlan, BackupPlanTags = BackupPlanTags, CreatorRequestId = CreatorRequestId)
  output <- .backup$create_backup_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$create_backup_plan <- backup_create_backup_plan

#' Creates a JSON document that specifies a set of resources to assign to a
#' backup plan
#'
#' @description
#' Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see [Assigning resources programmatically](https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json).
#'
#' See [https://www.paws-r-sdk.com/docs/backup_create_backup_selection/](https://www.paws-r-sdk.com/docs/backup_create_backup_selection/) for full documentation.
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies the backup plan to be associated with the selection
#' of resources.
#' @param BackupSelection &#91;required&#93; Specifies the body of a request to assign a set of resources to a backup
#' plan.
#' @param CreatorRequestId A unique string that identifies the request and allows failed requests
#' to be retried without the risk of running the operation twice. This
#' parameter is optional.
#' 
#' If used, this parameter must contain 1 to 50 alphanumeric or '-_.'
#' characters.
#'
#' @keywords internal
#'
#' @rdname backup_create_backup_selection
backup_create_backup_selection <- function(BackupPlanId, BackupSelection, CreatorRequestId = NULL) {
  op <- new_operation(
    name = "CreateBackupSelection",
    http_method = "PUT",
    http_path = "/backup/plans/{backupPlanId}/selections/",
    paginator = list()
  )
  input <- .backup$create_backup_selection_input(BackupPlanId = BackupPlanId, BackupSelection = BackupSelection, CreatorRequestId = CreatorRequestId)
  output <- .backup$create_backup_selection_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$create_backup_selection <- backup_create_backup_selection

#' Creates a logical container where backups are stored
#'
#' @description
#' Creates a logical container where backups are stored. A [`create_backup_vault`][backup_create_backup_vault] request includes a name, optionally one or more resource tags, an encryption key, and a request ID.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_create_backup_vault/](https://www.paws-r-sdk.com/docs/backup_create_backup_vault/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web Services Region where they are created. They
#' consist of letters, numbers, and hyphens.
#' @param BackupVaultTags Metadata that you can assign to help organize the resources that you
#' create. Each tag is a key-value pair.
#' @param EncryptionKeyArn The server-side encryption key that is used to protect your backups; for
#' example,
#' `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
#' @param CreatorRequestId A unique string that identifies the request and allows failed requests
#' to be retried without the risk of running the operation twice. This
#' parameter is optional.
#' 
#' If used, this parameter must contain 1 to 50 alphanumeric or '-_.'
#' characters.
#'
#' @keywords internal
#'
#' @rdname backup_create_backup_vault
backup_create_backup_vault <- function(BackupVaultName, BackupVaultTags = NULL, EncryptionKeyArn = NULL, CreatorRequestId = NULL) {
  op <- new_operation(
    name = "CreateBackupVault",
    http_method = "PUT",
    http_path = "/backup-vaults/{backupVaultName}",
    paginator = list()
  )
  input <- .backup$create_backup_vault_input(BackupVaultName = BackupVaultName, BackupVaultTags = BackupVaultTags, EncryptionKeyArn = EncryptionKeyArn, CreatorRequestId = CreatorRequestId)
  output <- .backup$create_backup_vault_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$create_backup_vault <- backup_create_backup_vault

#' Creates a framework with one or more controls
#'
#' @description
#' Creates a framework with one or more controls. A framework is a collection of controls that you can use to evaluate your backup practices. By using pre-built customizable controls to define your policies, you can evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_create_framework/](https://www.paws-r-sdk.com/docs/backup_create_framework/) for full documentation.
#'
#' @param FrameworkName &#91;required&#93; The unique name of the framework. The name must be between 1 and 256
#' characters, starting with a letter, and consisting of letters (a-z,
#' A-Z), numbers (0-9), and underscores (_).
#' @param FrameworkDescription An optional description of the framework with a maximum of 1,024
#' characters.
#' @param FrameworkControls &#91;required&#93; A list of the controls that make up the framework. Each control in the
#' list has a name, input parameters, and scope.
#' @param IdempotencyToken A customer-chosen string that you can use to distinguish between
#' otherwise identical calls to `CreateFrameworkInput`. Retrying a
#' successful request with the same idempotency token results in a success
#' message with no action taken.
#' @param FrameworkTags Metadata that you can assign to help organize the frameworks that you
#' create. Each tag is a key-value pair.
#'
#' @keywords internal
#'
#' @rdname backup_create_framework
backup_create_framework <- function(FrameworkName, FrameworkDescription = NULL, FrameworkControls, IdempotencyToken = NULL, FrameworkTags = NULL) {
  op <- new_operation(
    name = "CreateFramework",
    http_method = "POST",
    http_path = "/audit/frameworks",
    paginator = list()
  )
  input <- .backup$create_framework_input(FrameworkName = FrameworkName, FrameworkDescription = FrameworkDescription, FrameworkControls = FrameworkControls, IdempotencyToken = IdempotencyToken, FrameworkTags = FrameworkTags)
  output <- .backup$create_framework_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$create_framework <- backup_create_framework

#' This action creates a legal hold on a recovery point (backup)
#'
#' @description
#' This action creates a legal hold on a recovery point (backup). A legal hold is a restraint on altering or deleting a backup until an authorized user cancels the legal hold. Any actions to delete or disassociate a recovery point will fail with an error if one or more active legal holds are on the recovery point.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_create_legal_hold/](https://www.paws-r-sdk.com/docs/backup_create_legal_hold/) for full documentation.
#'
#' @param Title &#91;required&#93; This is the string title of the legal hold.
#' @param Description &#91;required&#93; This is the string description of the legal hold.
#' @param IdempotencyToken This is a user-chosen string used to distinguish between otherwise
#' identical calls. Retrying a successful request with the same idempotency
#' token results in a success message with no action taken.
#' @param RecoveryPointSelection This specifies criteria to assign a set of resources, such as resource
#' types or backup vaults.
#' @param Tags Optional tags to include. A tag is a key-value pair you can use to
#' manage, filter, and search for your resources. Allowed characters
#' include UTF-8 letters, numbers, spaces, and the following
#' characters: + - = . _ : /.
#'
#' @keywords internal
#'
#' @rdname backup_create_legal_hold
backup_create_legal_hold <- function(Title, Description, IdempotencyToken = NULL, RecoveryPointSelection = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateLegalHold",
    http_method = "POST",
    http_path = "/legal-holds/",
    paginator = list()
  )
  input <- .backup$create_legal_hold_input(Title = Title, Description = Description, IdempotencyToken = IdempotencyToken, RecoveryPointSelection = RecoveryPointSelection, Tags = Tags)
  output <- .backup$create_legal_hold_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$create_legal_hold <- backup_create_legal_hold

#' This request creates a logical container to where backups may be copied
#'
#' @description
#' This request creates a logical container to where backups may be copied.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_create_logically_air_gapped_backup_vault/](https://www.paws-r-sdk.com/docs/backup_create_logically_air_gapped_backup_vault/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; This is the name of the vault that is being created.
#' @param BackupVaultTags These are the tags that will be included in the newly-created vault.
#' @param CreatorRequestId This is the ID of the creation request.
#' 
#' This parameter is optional. If used, this parameter must contain 1 to 50
#' alphanumeric or '-_.' characters.
#' @param MinRetentionDays &#91;required&#93; This setting specifies the minimum retention period that the vault
#' retains its recovery points. If this parameter is not specified, no
#' minimum retention period is enforced.
#' 
#' If specified, any backup or copy job to the vault must have a lifecycle
#' policy with a retention period equal to or longer than the minimum
#' retention period. If a job retention period is shorter than that minimum
#' retention period, then the vault fails the backup or copy job, and you
#' should either modify your lifecycle settings or use a different vault.
#' @param MaxRetentionDays &#91;required&#93; This is the setting that specifies the maximum retention period that the
#' vault retains its recovery points. If this parameter is not specified,
#' Backup does not enforce a maximum retention period on the recovery
#' points in the vault (allowing indefinite storage).
#' 
#' If specified, any backup or copy job to the vault must have a lifecycle
#' policy with a retention period equal to or shorter than the maximum
#' retention period. If the job retention period is longer than that
#' maximum retention period, then the vault fails the backup or copy job,
#' and you should either modify your lifecycle settings or use a different
#' vault.
#'
#' @keywords internal
#'
#' @rdname backup_create_logically_air_gapped_backup_vault
backup_create_logically_air_gapped_backup_vault <- function(BackupVaultName, BackupVaultTags = NULL, CreatorRequestId = NULL, MinRetentionDays, MaxRetentionDays) {
  op <- new_operation(
    name = "CreateLogicallyAirGappedBackupVault",
    http_method = "PUT",
    http_path = "/logically-air-gapped-backup-vaults/{backupVaultName}",
    paginator = list()
  )
  input <- .backup$create_logically_air_gapped_backup_vault_input(BackupVaultName = BackupVaultName, BackupVaultTags = BackupVaultTags, CreatorRequestId = CreatorRequestId, MinRetentionDays = MinRetentionDays, MaxRetentionDays = MaxRetentionDays)
  output <- .backup$create_logically_air_gapped_backup_vault_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$create_logically_air_gapped_backup_vault <- backup_create_logically_air_gapped_backup_vault

#' Creates a report plan
#'
#' @description
#' Creates a report plan. A report plan is a document that contains information about the contents of the report and where Backup will deliver it.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_create_report_plan/](https://www.paws-r-sdk.com/docs/backup_create_report_plan/) for full documentation.
#'
#' @param ReportPlanName &#91;required&#93; The unique name of the report plan. The name must be between 1 and 256
#' characters, starting with a letter, and consisting of letters (a-z,
#' A-Z), numbers (0-9), and underscores (_).
#' @param ReportPlanDescription An optional description of the report plan with a maximum of 1,024
#' characters.
#' @param ReportDeliveryChannel &#91;required&#93; A structure that contains information about where and how to deliver
#' your reports, specifically your Amazon S3 bucket name, S3 key prefix,
#' and the formats of your reports.
#' @param ReportSetting &#91;required&#93; Identifies the report template for the report. Reports are built using a
#' report template. The report templates are:
#' 
#' `RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT`
#' 
#' If the report template is `RESOURCE_COMPLIANCE_REPORT` or
#' `CONTROL_COMPLIANCE_REPORT`, this API resource also describes the report
#' coverage by Amazon Web Services Regions and frameworks.
#' @param ReportPlanTags Metadata that you can assign to help organize the report plans that you
#' create. Each tag is a key-value pair.
#' @param IdempotencyToken A customer-chosen string that you can use to distinguish between
#' otherwise identical calls to `CreateReportPlanInput`. Retrying a
#' successful request with the same idempotency token results in a success
#' message with no action taken.
#'
#' @keywords internal
#'
#' @rdname backup_create_report_plan
backup_create_report_plan <- function(ReportPlanName, ReportPlanDescription = NULL, ReportDeliveryChannel, ReportSetting, ReportPlanTags = NULL, IdempotencyToken = NULL) {
  op <- new_operation(
    name = "CreateReportPlan",
    http_method = "POST",
    http_path = "/audit/report-plans",
    paginator = list()
  )
  input <- .backup$create_report_plan_input(ReportPlanName = ReportPlanName, ReportPlanDescription = ReportPlanDescription, ReportDeliveryChannel = ReportDeliveryChannel, ReportSetting = ReportSetting, ReportPlanTags = ReportPlanTags, IdempotencyToken = IdempotencyToken)
  output <- .backup$create_report_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$create_report_plan <- backup_create_report_plan

#' This is the first of two steps to create a restore testing plan; once
#' this request is successful, finish the procedure with request
#' CreateRestoreTestingSelection
#'
#' @description
#' This is the first of two steps to create a restore testing plan; once this request is successful, finish the procedure with request CreateRestoreTestingSelection.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_create_restore_testing_plan/](https://www.paws-r-sdk.com/docs/backup_create_restore_testing_plan/) for full documentation.
#'
#' @param CreatorRequestId This is a unique string that identifies the request and allows failed
#' requests to be retriedwithout the risk of running the operation twice.
#' This parameter is optional. If used, this parameter must contain 1 to 50
#' alphanumeric or '-_.' characters.
#' @param RestoreTestingPlan &#91;required&#93; A restore testing plan must contain a unique `RestoreTestingPlanName`
#' string you create and must contain a `ScheduleExpression` cron. You may
#' optionally include a `StartWindowHours` integer and a `CreatorRequestId`
#' string.
#' 
#' The `RestoreTestingPlanName` is a unique string that is the name of the
#' restore testing plan. This cannot be changed after creation, and it must
#' consist of only alphanumeric characters and underscores.
#' @param Tags Optional tags to include. A tag is a key-value pair you can use to
#' manage, filter, and search for your resources. Allowed characters
#' include UTF-8 letters,numbers, spaces, and the following characters: + -
#' = . _ : /.
#'
#' @keywords internal
#'
#' @rdname backup_create_restore_testing_plan
backup_create_restore_testing_plan <- function(CreatorRequestId = NULL, RestoreTestingPlan, Tags = NULL) {
  op <- new_operation(
    name = "CreateRestoreTestingPlan",
    http_method = "PUT",
    http_path = "/restore-testing/plans",
    paginator = list()
  )
  input <- .backup$create_restore_testing_plan_input(CreatorRequestId = CreatorRequestId, RestoreTestingPlan = RestoreTestingPlan, Tags = Tags)
  output <- .backup$create_restore_testing_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$create_restore_testing_plan <- backup_create_restore_testing_plan

#' This request can be sent after CreateRestoreTestingPlan request returns
#' successfully
#'
#' @description
#' This request can be sent after CreateRestoreTestingPlan request returns successfully. This is the second part of creating a resource testing plan, and it must be completed sequentially.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_create_restore_testing_selection/](https://www.paws-r-sdk.com/docs/backup_create_restore_testing_selection/) for full documentation.
#'
#' @param CreatorRequestId This is an optional unique string that identifies the request and allows
#' failed requests to be retried without the risk of running the operation
#' twice. If used, this parameter must contain 1 to 50 alphanumeric or
#' '-_.' characters.
#' @param RestoreTestingPlanName &#91;required&#93; Input the restore testing plan name that was returned from the related
#' CreateRestoreTestingPlan request.
#' @param RestoreTestingSelection &#91;required&#93; This consists of `RestoreTestingSelectionName`, `ProtectedResourceType`,
#' and one of the following:
#' 
#' -   `ProtectedResourceArns`
#' 
#' -   `ProtectedResourceConditions`
#' 
#' Each protected resource type can have one single value.
#' 
#' A restore testing selection can include a wildcard value ("*") for
#' `ProtectedResourceArns` along with `ProtectedResourceConditions`.
#' Alternatively, you can include up to 30 specific protected resource ARNs
#' in `ProtectedResourceArns`.
#'
#' @keywords internal
#'
#' @rdname backup_create_restore_testing_selection
backup_create_restore_testing_selection <- function(CreatorRequestId = NULL, RestoreTestingPlanName, RestoreTestingSelection) {
  op <- new_operation(
    name = "CreateRestoreTestingSelection",
    http_method = "PUT",
    http_path = "/restore-testing/plans/{RestoreTestingPlanName}/selections",
    paginator = list()
  )
  input <- .backup$create_restore_testing_selection_input(CreatorRequestId = CreatorRequestId, RestoreTestingPlanName = RestoreTestingPlanName, RestoreTestingSelection = RestoreTestingSelection)
  output <- .backup$create_restore_testing_selection_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$create_restore_testing_selection <- backup_create_restore_testing_selection

#' Deletes a backup plan
#'
#' @description
#' Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will still exist.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_delete_backup_plan/](https://www.paws-r-sdk.com/docs/backup_delete_backup_plan/) for full documentation.
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#'
#' @keywords internal
#'
#' @rdname backup_delete_backup_plan
backup_delete_backup_plan <- function(BackupPlanId) {
  op <- new_operation(
    name = "DeleteBackupPlan",
    http_method = "DELETE",
    http_path = "/backup/plans/{backupPlanId}",
    paginator = list()
  )
  input <- .backup$delete_backup_plan_input(BackupPlanId = BackupPlanId)
  output <- .backup$delete_backup_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_backup_plan <- backup_delete_backup_plan

#' Deletes the resource selection associated with a backup plan that is
#' specified by the SelectionId
#'
#' @description
#' Deletes the resource selection associated with a backup plan that is specified by the `SelectionId`.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_delete_backup_selection/](https://www.paws-r-sdk.com/docs/backup_delete_backup_selection/) for full documentation.
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#' @param SelectionId &#91;required&#93; Uniquely identifies the body of a request to assign a set of resources
#' to a backup plan.
#'
#' @keywords internal
#'
#' @rdname backup_delete_backup_selection
backup_delete_backup_selection <- function(BackupPlanId, SelectionId) {
  op <- new_operation(
    name = "DeleteBackupSelection",
    http_method = "DELETE",
    http_path = "/backup/plans/{backupPlanId}/selections/{selectionId}",
    paginator = list()
  )
  input <- .backup$delete_backup_selection_input(BackupPlanId = BackupPlanId, SelectionId = SelectionId)
  output <- .backup$delete_backup_selection_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_backup_selection <- backup_delete_backup_selection

#' Deletes the backup vault identified by its name
#'
#' @description
#' Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_delete_backup_vault/](https://www.paws-r-sdk.com/docs/backup_delete_backup_vault/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web Services Region where they are created. They
#' consist of lowercase letters, numbers, and hyphens.
#'
#' @keywords internal
#'
#' @rdname backup_delete_backup_vault
backup_delete_backup_vault <- function(BackupVaultName) {
  op <- new_operation(
    name = "DeleteBackupVault",
    http_method = "DELETE",
    http_path = "/backup-vaults/{backupVaultName}",
    paginator = list()
  )
  input <- .backup$delete_backup_vault_input(BackupVaultName = BackupVaultName)
  output <- .backup$delete_backup_vault_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_backup_vault <- backup_delete_backup_vault

#' Deletes the policy document that manages permissions on a backup vault
#'
#' @description
#' Deletes the policy document that manages permissions on a backup vault.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_delete_backup_vault_access_policy/](https://www.paws-r-sdk.com/docs/backup_delete_backup_vault_access_policy/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web Services Region where they are created. They
#' consist of lowercase letters, numbers, and hyphens.
#'
#' @keywords internal
#'
#' @rdname backup_delete_backup_vault_access_policy
backup_delete_backup_vault_access_policy <- function(BackupVaultName) {
  op <- new_operation(
    name = "DeleteBackupVaultAccessPolicy",
    http_method = "DELETE",
    http_path = "/backup-vaults/{backupVaultName}/access-policy",
    paginator = list()
  )
  input <- .backup$delete_backup_vault_access_policy_input(BackupVaultName = BackupVaultName)
  output <- .backup$delete_backup_vault_access_policy_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_backup_vault_access_policy <- backup_delete_backup_vault_access_policy

#' Deletes Backup Vault Lock from a backup vault specified by a backup
#' vault name
#'
#' @description
#' Deletes Backup Vault Lock from a backup vault specified by a backup vault name.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_delete_backup_vault_lock_configuration/](https://www.paws-r-sdk.com/docs/backup_delete_backup_vault_lock_configuration/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of the backup vault from which to delete Backup Vault Lock.
#'
#' @keywords internal
#'
#' @rdname backup_delete_backup_vault_lock_configuration
backup_delete_backup_vault_lock_configuration <- function(BackupVaultName) {
  op <- new_operation(
    name = "DeleteBackupVaultLockConfiguration",
    http_method = "DELETE",
    http_path = "/backup-vaults/{backupVaultName}/vault-lock",
    paginator = list()
  )
  input <- .backup$delete_backup_vault_lock_configuration_input(BackupVaultName = BackupVaultName)
  output <- .backup$delete_backup_vault_lock_configuration_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_backup_vault_lock_configuration <- backup_delete_backup_vault_lock_configuration

#' Deletes event notifications for the specified backup vault
#'
#' @description
#' Deletes event notifications for the specified backup vault.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_delete_backup_vault_notifications/](https://www.paws-r-sdk.com/docs/backup_delete_backup_vault_notifications/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Region where they are created. They consist of lowercase
#' letters, numbers, and hyphens.
#'
#' @keywords internal
#'
#' @rdname backup_delete_backup_vault_notifications
backup_delete_backup_vault_notifications <- function(BackupVaultName) {
  op <- new_operation(
    name = "DeleteBackupVaultNotifications",
    http_method = "DELETE",
    http_path = "/backup-vaults/{backupVaultName}/notification-configuration",
    paginator = list()
  )
  input <- .backup$delete_backup_vault_notifications_input(BackupVaultName = BackupVaultName)
  output <- .backup$delete_backup_vault_notifications_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_backup_vault_notifications <- backup_delete_backup_vault_notifications

#' Deletes the framework specified by a framework name
#'
#' @description
#' Deletes the framework specified by a framework name.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_delete_framework/](https://www.paws-r-sdk.com/docs/backup_delete_framework/) for full documentation.
#'
#' @param FrameworkName &#91;required&#93; The unique name of a framework.
#'
#' @keywords internal
#'
#' @rdname backup_delete_framework
backup_delete_framework <- function(FrameworkName) {
  op <- new_operation(
    name = "DeleteFramework",
    http_method = "DELETE",
    http_path = "/audit/frameworks/{frameworkName}",
    paginator = list()
  )
  input <- .backup$delete_framework_input(FrameworkName = FrameworkName)
  output <- .backup$delete_framework_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_framework <- backup_delete_framework

#' Deletes the recovery point specified by a recovery point ID
#'
#' @description
#' Deletes the recovery point specified by a recovery point ID.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_delete_recovery_point/](https://www.paws-r-sdk.com/docs/backup_delete_recovery_point/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web Services Region where they are created. They
#' consist of lowercase letters, numbers, and hyphens.
#' @param RecoveryPointArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
#' for example,
#' `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
#'
#' @keywords internal
#'
#' @rdname backup_delete_recovery_point
backup_delete_recovery_point <- function(BackupVaultName, RecoveryPointArn) {
  op <- new_operation(
    name = "DeleteRecoveryPoint",
    http_method = "DELETE",
    http_path = "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}",
    paginator = list()
  )
  input <- .backup$delete_recovery_point_input(BackupVaultName = BackupVaultName, RecoveryPointArn = RecoveryPointArn)
  output <- .backup$delete_recovery_point_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_recovery_point <- backup_delete_recovery_point

#' Deletes the report plan specified by a report plan name
#'
#' @description
#' Deletes the report plan specified by a report plan name.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_delete_report_plan/](https://www.paws-r-sdk.com/docs/backup_delete_report_plan/) for full documentation.
#'
#' @param ReportPlanName &#91;required&#93; The unique name of a report plan.
#'
#' @keywords internal
#'
#' @rdname backup_delete_report_plan
backup_delete_report_plan <- function(ReportPlanName) {
  op <- new_operation(
    name = "DeleteReportPlan",
    http_method = "DELETE",
    http_path = "/audit/report-plans/{reportPlanName}",
    paginator = list()
  )
  input <- .backup$delete_report_plan_input(ReportPlanName = ReportPlanName)
  output <- .backup$delete_report_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_report_plan <- backup_delete_report_plan

#' This request deletes the specified restore testing plan
#'
#' @description
#' This request deletes the specified restore testing plan.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_delete_restore_testing_plan/](https://www.paws-r-sdk.com/docs/backup_delete_restore_testing_plan/) for full documentation.
#'
#' @param RestoreTestingPlanName &#91;required&#93; Required unique name of the restore testing plan you wish to delete.
#'
#' @keywords internal
#'
#' @rdname backup_delete_restore_testing_plan
backup_delete_restore_testing_plan <- function(RestoreTestingPlanName) {
  op <- new_operation(
    name = "DeleteRestoreTestingPlan",
    http_method = "DELETE",
    http_path = "/restore-testing/plans/{RestoreTestingPlanName}",
    paginator = list()
  )
  input <- .backup$delete_restore_testing_plan_input(RestoreTestingPlanName = RestoreTestingPlanName)
  output <- .backup$delete_restore_testing_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_restore_testing_plan <- backup_delete_restore_testing_plan

#' Input the Restore Testing Plan name and Restore Testing Selection name
#'
#' @description
#' Input the Restore Testing Plan name and Restore Testing Selection name.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_delete_restore_testing_selection/](https://www.paws-r-sdk.com/docs/backup_delete_restore_testing_selection/) for full documentation.
#'
#' @param RestoreTestingPlanName &#91;required&#93; Required unique name of the restore testing plan that contains the
#' restore testing selection you wish to delete.
#' @param RestoreTestingSelectionName &#91;required&#93; Required unique name of the restore testing selection you wish to
#' delete.
#'
#' @keywords internal
#'
#' @rdname backup_delete_restore_testing_selection
backup_delete_restore_testing_selection <- function(RestoreTestingPlanName, RestoreTestingSelectionName) {
  op <- new_operation(
    name = "DeleteRestoreTestingSelection",
    http_method = "DELETE",
    http_path = "/restore-testing/plans/{RestoreTestingPlanName}/selections/{RestoreTestingSelectionName}",
    paginator = list()
  )
  input <- .backup$delete_restore_testing_selection_input(RestoreTestingPlanName = RestoreTestingPlanName, RestoreTestingSelectionName = RestoreTestingSelectionName)
  output <- .backup$delete_restore_testing_selection_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$delete_restore_testing_selection <- backup_delete_restore_testing_selection

#' Returns backup job details for the specified BackupJobId
#'
#' @description
#' Returns backup job details for the specified `BackupJobId`.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_describe_backup_job/](https://www.paws-r-sdk.com/docs/backup_describe_backup_job/) for full documentation.
#'
#' @param BackupJobId &#91;required&#93; Uniquely identifies a request to Backup to back up a resource.
#'
#' @keywords internal
#'
#' @rdname backup_describe_backup_job
backup_describe_backup_job <- function(BackupJobId) {
  op <- new_operation(
    name = "DescribeBackupJob",
    http_method = "GET",
    http_path = "/backup-jobs/{backupJobId}",
    paginator = list()
  )
  input <- .backup$describe_backup_job_input(BackupJobId = BackupJobId)
  output <- .backup$describe_backup_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_backup_job <- backup_describe_backup_job

#' Returns metadata about a backup vault specified by its name
#'
#' @description
#' Returns metadata about a backup vault specified by its name.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_describe_backup_vault/](https://www.paws-r-sdk.com/docs/backup_describe_backup_vault/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web Services Region where they are created. They
#' consist of lowercase letters, numbers, and hyphens.
#' @param BackupVaultAccountId This is the account ID of the specified backup vault.
#'
#' @keywords internal
#'
#' @rdname backup_describe_backup_vault
backup_describe_backup_vault <- function(BackupVaultName, BackupVaultAccountId = NULL) {
  op <- new_operation(
    name = "DescribeBackupVault",
    http_method = "GET",
    http_path = "/backup-vaults/{backupVaultName}",
    paginator = list()
  )
  input <- .backup$describe_backup_vault_input(BackupVaultName = BackupVaultName, BackupVaultAccountId = BackupVaultAccountId)
  output <- .backup$describe_backup_vault_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_backup_vault <- backup_describe_backup_vault

#' Returns metadata associated with creating a copy of a resource
#'
#' @description
#' Returns metadata associated with creating a copy of a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_describe_copy_job/](https://www.paws-r-sdk.com/docs/backup_describe_copy_job/) for full documentation.
#'
#' @param CopyJobId &#91;required&#93; Uniquely identifies a copy job.
#'
#' @keywords internal
#'
#' @rdname backup_describe_copy_job
backup_describe_copy_job <- function(CopyJobId) {
  op <- new_operation(
    name = "DescribeCopyJob",
    http_method = "GET",
    http_path = "/copy-jobs/{copyJobId}",
    paginator = list()
  )
  input <- .backup$describe_copy_job_input(CopyJobId = CopyJobId)
  output <- .backup$describe_copy_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_copy_job <- backup_describe_copy_job

#' Returns the framework details for the specified FrameworkName
#'
#' @description
#' Returns the framework details for the specified `FrameworkName`.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_describe_framework/](https://www.paws-r-sdk.com/docs/backup_describe_framework/) for full documentation.
#'
#' @param FrameworkName &#91;required&#93; The unique name of a framework.
#'
#' @keywords internal
#'
#' @rdname backup_describe_framework
backup_describe_framework <- function(FrameworkName) {
  op <- new_operation(
    name = "DescribeFramework",
    http_method = "GET",
    http_path = "/audit/frameworks/{frameworkName}",
    paginator = list()
  )
  input <- .backup$describe_framework_input(FrameworkName = FrameworkName)
  output <- .backup$describe_framework_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_framework <- backup_describe_framework

#' Describes whether the Amazon Web Services account is opted in to
#' cross-account backup
#'
#' @description
#' Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not a member of an Organizations organization. Example: `describe-global-settings --region us-west-2`
#'
#' See [https://www.paws-r-sdk.com/docs/backup_describe_global_settings/](https://www.paws-r-sdk.com/docs/backup_describe_global_settings/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname backup_describe_global_settings
backup_describe_global_settings <- function() {
  op <- new_operation(
    name = "DescribeGlobalSettings",
    http_method = "GET",
    http_path = "/global-settings",
    paginator = list()
  )
  input <- .backup$describe_global_settings_input()
  output <- .backup$describe_global_settings_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_global_settings <- backup_describe_global_settings

#' Returns information about a saved resource, including the last time it
#' was backed up, its Amazon Resource Name (ARN), and the Amazon Web
#' Services service type of the saved resource
#'
#' @description
#' Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name (ARN), and the Amazon Web Services service type of the saved resource.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_describe_protected_resource/](https://www.paws-r-sdk.com/docs/backup_describe_protected_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a resource. The
#' format of the ARN depends on the resource type.
#'
#' @keywords internal
#'
#' @rdname backup_describe_protected_resource
backup_describe_protected_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "DescribeProtectedResource",
    http_method = "GET",
    http_path = "/resources/{resourceArn}",
    paginator = list()
  )
  input <- .backup$describe_protected_resource_input(ResourceArn = ResourceArn)
  output <- .backup$describe_protected_resource_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_protected_resource <- backup_describe_protected_resource

#' Returns metadata associated with a recovery point, including ID, status,
#' encryption, and lifecycle
#'
#' @description
#' Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_describe_recovery_point/](https://www.paws-r-sdk.com/docs/backup_describe_recovery_point/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web Services Region where they are created. They
#' consist of lowercase letters, numbers, and hyphens.
#' @param RecoveryPointArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
#' for example,
#' `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
#' @param BackupVaultAccountId This is the account ID of the specified backup vault.
#'
#' @keywords internal
#'
#' @rdname backup_describe_recovery_point
backup_describe_recovery_point <- function(BackupVaultName, RecoveryPointArn, BackupVaultAccountId = NULL) {
  op <- new_operation(
    name = "DescribeRecoveryPoint",
    http_method = "GET",
    http_path = "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}",
    paginator = list()
  )
  input <- .backup$describe_recovery_point_input(BackupVaultName = BackupVaultName, RecoveryPointArn = RecoveryPointArn, BackupVaultAccountId = BackupVaultAccountId)
  output <- .backup$describe_recovery_point_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_recovery_point <- backup_describe_recovery_point

#' Returns the current service opt-in settings for the Region
#'
#' @description
#' Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_describe_region_settings/](https://www.paws-r-sdk.com/docs/backup_describe_region_settings/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname backup_describe_region_settings
backup_describe_region_settings <- function() {
  op <- new_operation(
    name = "DescribeRegionSettings",
    http_method = "GET",
    http_path = "/account-settings",
    paginator = list()
  )
  input <- .backup$describe_region_settings_input()
  output <- .backup$describe_region_settings_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_region_settings <- backup_describe_region_settings

#' Returns the details associated with creating a report as specified by
#' its ReportJobId
#'
#' @description
#' Returns the details associated with creating a report as specified by its `ReportJobId`.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_describe_report_job/](https://www.paws-r-sdk.com/docs/backup_describe_report_job/) for full documentation.
#'
#' @param ReportJobId &#91;required&#93; The identifier of the report job. A unique, randomly generated, Unicode,
#' UTF-8 encoded string that is at most 1,024 bytes long. The report job ID
#' cannot be edited.
#'
#' @keywords internal
#'
#' @rdname backup_describe_report_job
backup_describe_report_job <- function(ReportJobId) {
  op <- new_operation(
    name = "DescribeReportJob",
    http_method = "GET",
    http_path = "/audit/report-jobs/{reportJobId}",
    paginator = list()
  )
  input <- .backup$describe_report_job_input(ReportJobId = ReportJobId)
  output <- .backup$describe_report_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_report_job <- backup_describe_report_job

#' Returns a list of all report plans for an Amazon Web Services account
#' and Amazon Web Services Region
#'
#' @description
#' Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_describe_report_plan/](https://www.paws-r-sdk.com/docs/backup_describe_report_plan/) for full documentation.
#'
#' @param ReportPlanName &#91;required&#93; The unique name of a report plan.
#'
#' @keywords internal
#'
#' @rdname backup_describe_report_plan
backup_describe_report_plan <- function(ReportPlanName) {
  op <- new_operation(
    name = "DescribeReportPlan",
    http_method = "GET",
    http_path = "/audit/report-plans/{reportPlanName}",
    paginator = list()
  )
  input <- .backup$describe_report_plan_input(ReportPlanName = ReportPlanName)
  output <- .backup$describe_report_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_report_plan <- backup_describe_report_plan

#' Returns metadata associated with a restore job that is specified by a
#' job ID
#'
#' @description
#' Returns metadata associated with a restore job that is specified by a job ID.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_describe_restore_job/](https://www.paws-r-sdk.com/docs/backup_describe_restore_job/) for full documentation.
#'
#' @param RestoreJobId &#91;required&#93; Uniquely identifies the job that restores a recovery point.
#'
#' @keywords internal
#'
#' @rdname backup_describe_restore_job
backup_describe_restore_job <- function(RestoreJobId) {
  op <- new_operation(
    name = "DescribeRestoreJob",
    http_method = "GET",
    http_path = "/restore-jobs/{restoreJobId}",
    paginator = list()
  )
  input <- .backup$describe_restore_job_input(RestoreJobId = RestoreJobId)
  output <- .backup$describe_restore_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$describe_restore_job <- backup_describe_restore_job

#' Deletes the specified continuous backup recovery point from Backup and
#' releases control of that continuous backup to the source service, such
#' as Amazon RDS
#'
#' @description
#' Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup to the source service, such as Amazon RDS. The source service will continue to create and retain continuous backups using the lifecycle that you specified in your original backup plan.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_disassociate_recovery_point/](https://www.paws-r-sdk.com/docs/backup_disassociate_recovery_point/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The unique name of an Backup vault.
#' @param RecoveryPointArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies an Backup
#' recovery point.
#'
#' @keywords internal
#'
#' @rdname backup_disassociate_recovery_point
backup_disassociate_recovery_point <- function(BackupVaultName, RecoveryPointArn) {
  op <- new_operation(
    name = "DisassociateRecoveryPoint",
    http_method = "POST",
    http_path = "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}/disassociate",
    paginator = list()
  )
  input <- .backup$disassociate_recovery_point_input(BackupVaultName = BackupVaultName, RecoveryPointArn = RecoveryPointArn)
  output <- .backup$disassociate_recovery_point_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$disassociate_recovery_point <- backup_disassociate_recovery_point

#' This action to a specific child (nested) recovery point removes the
#' relationship between the specified recovery point and its parent
#' (composite) recovery point
#'
#' @description
#' This action to a specific child (nested) recovery point removes the relationship between the specified recovery point and its parent (composite) recovery point.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_disassociate_recovery_point_from_parent/](https://www.paws-r-sdk.com/docs/backup_disassociate_recovery_point_from_parent/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; This is the name of a logical container where the child (nested)
#' recovery point is stored. Backup vaults are identified by names that are
#' unique to the account used to create them and the Amazon Web Services
#' Region where they are created. They consist of lowercase letters,
#' numbers, and hyphens.
#' @param RecoveryPointArn &#91;required&#93; This is the Amazon Resource Name (ARN) that uniquely identifies the
#' child (nested) recovery point; for example,
#' `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.`
#'
#' @keywords internal
#'
#' @rdname backup_disassociate_recovery_point_from_parent
backup_disassociate_recovery_point_from_parent <- function(BackupVaultName, RecoveryPointArn) {
  op <- new_operation(
    name = "DisassociateRecoveryPointFromParent",
    http_method = "DELETE",
    http_path = "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}/parentAssociation",
    paginator = list()
  )
  input <- .backup$disassociate_recovery_point_from_parent_input(BackupVaultName = BackupVaultName, RecoveryPointArn = RecoveryPointArn)
  output <- .backup$disassociate_recovery_point_from_parent_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$disassociate_recovery_point_from_parent <- backup_disassociate_recovery_point_from_parent

#' Returns the backup plan that is specified by the plan ID as a backup
#' template
#'
#' @description
#' Returns the backup plan that is specified by the plan ID as a backup template.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_export_backup_plan_template/](https://www.paws-r-sdk.com/docs/backup_export_backup_plan_template/) for full documentation.
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#'
#' @keywords internal
#'
#' @rdname backup_export_backup_plan_template
backup_export_backup_plan_template <- function(BackupPlanId) {
  op <- new_operation(
    name = "ExportBackupPlanTemplate",
    http_method = "GET",
    http_path = "/backup/plans/{backupPlanId}/toTemplate/",
    paginator = list()
  )
  input <- .backup$export_backup_plan_template_input(BackupPlanId = BackupPlanId)
  output <- .backup$export_backup_plan_template_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$export_backup_plan_template <- backup_export_backup_plan_template

#' Returns BackupPlan details for the specified BackupPlanId
#'
#' @description
#' Returns `BackupPlan` details for the specified `BackupPlanId`. The details are the body of a backup plan in JSON format, in addition to plan metadata.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_get_backup_plan/](https://www.paws-r-sdk.com/docs/backup_get_backup_plan/) for full documentation.
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#' @param VersionId Unique, randomly generated, Unicode, UTF-8 encoded strings that are at
#' most 1,024 bytes long. Version IDs cannot be edited.
#'
#' @keywords internal
#'
#' @rdname backup_get_backup_plan
backup_get_backup_plan <- function(BackupPlanId, VersionId = NULL) {
  op <- new_operation(
    name = "GetBackupPlan",
    http_method = "GET",
    http_path = "/backup/plans/{backupPlanId}/",
    paginator = list()
  )
  input <- .backup$get_backup_plan_input(BackupPlanId = BackupPlanId, VersionId = VersionId)
  output <- .backup$get_backup_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_backup_plan <- backup_get_backup_plan

#' Returns a valid JSON document specifying a backup plan or an error
#'
#' @description
#' Returns a valid JSON document specifying a backup plan or an error.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_get_backup_plan_from_json/](https://www.paws-r-sdk.com/docs/backup_get_backup_plan_from_json/) for full documentation.
#'
#' @param BackupPlanTemplateJson &#91;required&#93; A customer-supplied backup plan document in JSON format.
#'
#' @keywords internal
#'
#' @rdname backup_get_backup_plan_from_json
backup_get_backup_plan_from_json <- function(BackupPlanTemplateJson) {
  op <- new_operation(
    name = "GetBackupPlanFromJSON",
    http_method = "POST",
    http_path = "/backup/template/json/toPlan",
    paginator = list()
  )
  input <- .backup$get_backup_plan_from_json_input(BackupPlanTemplateJson = BackupPlanTemplateJson)
  output <- .backup$get_backup_plan_from_json_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_backup_plan_from_json <- backup_get_backup_plan_from_json

#' Returns the template specified by its templateId as a backup plan
#'
#' @description
#' Returns the template specified by its `templateId` as a backup plan.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_get_backup_plan_from_template/](https://www.paws-r-sdk.com/docs/backup_get_backup_plan_from_template/) for full documentation.
#'
#' @param BackupPlanTemplateId &#91;required&#93; Uniquely identifies a stored backup plan template.
#'
#' @keywords internal
#'
#' @rdname backup_get_backup_plan_from_template
backup_get_backup_plan_from_template <- function(BackupPlanTemplateId) {
  op <- new_operation(
    name = "GetBackupPlanFromTemplate",
    http_method = "GET",
    http_path = "/backup/template/plans/{templateId}/toPlan",
    paginator = list()
  )
  input <- .backup$get_backup_plan_from_template_input(BackupPlanTemplateId = BackupPlanTemplateId)
  output <- .backup$get_backup_plan_from_template_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_backup_plan_from_template <- backup_get_backup_plan_from_template

#' Returns selection metadata and a document in JSON format that specifies
#' a list of resources that are associated with a backup plan
#'
#' @description
#' Returns selection metadata and a document in JSON format that specifies a list of resources that are associated with a backup plan.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_get_backup_selection/](https://www.paws-r-sdk.com/docs/backup_get_backup_selection/) for full documentation.
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#' @param SelectionId &#91;required&#93; Uniquely identifies the body of a request to assign a set of resources
#' to a backup plan.
#'
#' @keywords internal
#'
#' @rdname backup_get_backup_selection
backup_get_backup_selection <- function(BackupPlanId, SelectionId) {
  op <- new_operation(
    name = "GetBackupSelection",
    http_method = "GET",
    http_path = "/backup/plans/{backupPlanId}/selections/{selectionId}",
    paginator = list()
  )
  input <- .backup$get_backup_selection_input(BackupPlanId = BackupPlanId, SelectionId = SelectionId)
  output <- .backup$get_backup_selection_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_backup_selection <- backup_get_backup_selection

#' Returns the access policy document that is associated with the named
#' backup vault
#'
#' @description
#' Returns the access policy document that is associated with the named backup vault.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_get_backup_vault_access_policy/](https://www.paws-r-sdk.com/docs/backup_get_backup_vault_access_policy/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web Services Region where they are created. They
#' consist of lowercase letters, numbers, and hyphens.
#'
#' @keywords internal
#'
#' @rdname backup_get_backup_vault_access_policy
backup_get_backup_vault_access_policy <- function(BackupVaultName) {
  op <- new_operation(
    name = "GetBackupVaultAccessPolicy",
    http_method = "GET",
    http_path = "/backup-vaults/{backupVaultName}/access-policy",
    paginator = list()
  )
  input <- .backup$get_backup_vault_access_policy_input(BackupVaultName = BackupVaultName)
  output <- .backup$get_backup_vault_access_policy_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_backup_vault_access_policy <- backup_get_backup_vault_access_policy

#' Returns event notifications for the specified backup vault
#'
#' @description
#' Returns event notifications for the specified backup vault.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_get_backup_vault_notifications/](https://www.paws-r-sdk.com/docs/backup_get_backup_vault_notifications/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web Services Region where they are created. They
#' consist of lowercase letters, numbers, and hyphens.
#'
#' @keywords internal
#'
#' @rdname backup_get_backup_vault_notifications
backup_get_backup_vault_notifications <- function(BackupVaultName) {
  op <- new_operation(
    name = "GetBackupVaultNotifications",
    http_method = "GET",
    http_path = "/backup-vaults/{backupVaultName}/notification-configuration",
    paginator = list()
  )
  input <- .backup$get_backup_vault_notifications_input(BackupVaultName = BackupVaultName)
  output <- .backup$get_backup_vault_notifications_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_backup_vault_notifications <- backup_get_backup_vault_notifications

#' This action returns details for a specified legal hold
#'
#' @description
#' This action returns details for a specified legal hold. The details are the body of a legal hold in JSON format, in addition to metadata.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_get_legal_hold/](https://www.paws-r-sdk.com/docs/backup_get_legal_hold/) for full documentation.
#'
#' @param LegalHoldId &#91;required&#93; This is the ID required to use
#' [`get_legal_hold`][backup_get_legal_hold]. This unique ID is associated
#' with a specific legal hold.
#'
#' @keywords internal
#'
#' @rdname backup_get_legal_hold
backup_get_legal_hold <- function(LegalHoldId) {
  op <- new_operation(
    name = "GetLegalHold",
    http_method = "GET",
    http_path = "/legal-holds/{legalHoldId}/",
    paginator = list()
  )
  input <- .backup$get_legal_hold_input(LegalHoldId = LegalHoldId)
  output <- .backup$get_legal_hold_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_legal_hold <- backup_get_legal_hold

#' Returns a set of metadata key-value pairs that were used to create the
#' backup
#'
#' @description
#' Returns a set of metadata key-value pairs that were used to create the backup.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_get_recovery_point_restore_metadata/](https://www.paws-r-sdk.com/docs/backup_get_recovery_point_restore_metadata/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web Services Region where they are created. They
#' consist of lowercase letters, numbers, and hyphens.
#' @param RecoveryPointArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
#' for example,
#' `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
#' @param BackupVaultAccountId This is the account ID of the specified backup vault.
#'
#' @keywords internal
#'
#' @rdname backup_get_recovery_point_restore_metadata
backup_get_recovery_point_restore_metadata <- function(BackupVaultName, RecoveryPointArn, BackupVaultAccountId = NULL) {
  op <- new_operation(
    name = "GetRecoveryPointRestoreMetadata",
    http_method = "GET",
    http_path = "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}/restore-metadata",
    paginator = list()
  )
  input <- .backup$get_recovery_point_restore_metadata_input(BackupVaultName = BackupVaultName, RecoveryPointArn = RecoveryPointArn, BackupVaultAccountId = BackupVaultAccountId)
  output <- .backup$get_recovery_point_restore_metadata_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_recovery_point_restore_metadata <- backup_get_recovery_point_restore_metadata

#' This request returns the metadata for the specified restore job
#'
#' @description
#' This request returns the metadata for the specified restore job.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_get_restore_job_metadata/](https://www.paws-r-sdk.com/docs/backup_get_restore_job_metadata/) for full documentation.
#'
#' @param RestoreJobId &#91;required&#93; This is a unique identifier of a restore job within Backup.
#'
#' @keywords internal
#'
#' @rdname backup_get_restore_job_metadata
backup_get_restore_job_metadata <- function(RestoreJobId) {
  op <- new_operation(
    name = "GetRestoreJobMetadata",
    http_method = "GET",
    http_path = "/restore-jobs/{restoreJobId}/metadata",
    paginator = list()
  )
  input <- .backup$get_restore_job_metadata_input(RestoreJobId = RestoreJobId)
  output <- .backup$get_restore_job_metadata_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_restore_job_metadata <- backup_get_restore_job_metadata

#' This request returns the minimal required set of metadata needed to
#' start a restore job with secure default settings
#'
#' @description
#' This request returns the minimal required set of metadata needed to start a restore job with secure default settings. `BackupVaultName` and `RecoveryPointArn` are required parameters. `BackupVaultAccountId` is an optional parameter.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_get_restore_testing_inferred_metadata/](https://www.paws-r-sdk.com/docs/backup_get_restore_testing_inferred_metadata/) for full documentation.
#'
#' @param BackupVaultAccountId This is the account ID of the specified backup vault.
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web ServicesRegion where they are created. They
#' consist of letters, numbers, and hyphens.
#' @param RecoveryPointArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
#' for example,
#' `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
#'
#' @keywords internal
#'
#' @rdname backup_get_restore_testing_inferred_metadata
backup_get_restore_testing_inferred_metadata <- function(BackupVaultAccountId = NULL, BackupVaultName, RecoveryPointArn) {
  op <- new_operation(
    name = "GetRestoreTestingInferredMetadata",
    http_method = "GET",
    http_path = "/restore-testing/inferred-metadata",
    paginator = list()
  )
  input <- .backup$get_restore_testing_inferred_metadata_input(BackupVaultAccountId = BackupVaultAccountId, BackupVaultName = BackupVaultName, RecoveryPointArn = RecoveryPointArn)
  output <- .backup$get_restore_testing_inferred_metadata_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_restore_testing_inferred_metadata <- backup_get_restore_testing_inferred_metadata

#' Returns RestoreTestingPlan details for the specified
#' RestoreTestingPlanName
#'
#' @description
#' Returns `RestoreTestingPlan` details for the specified `RestoreTestingPlanName`. The details are the body of a restore testing plan in JSON format, in addition to plan metadata.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_get_restore_testing_plan/](https://www.paws-r-sdk.com/docs/backup_get_restore_testing_plan/) for full documentation.
#'
#' @param RestoreTestingPlanName &#91;required&#93; Required unique name of the restore testing plan.
#'
#' @keywords internal
#'
#' @rdname backup_get_restore_testing_plan
backup_get_restore_testing_plan <- function(RestoreTestingPlanName) {
  op <- new_operation(
    name = "GetRestoreTestingPlan",
    http_method = "GET",
    http_path = "/restore-testing/plans/{RestoreTestingPlanName}",
    paginator = list()
  )
  input <- .backup$get_restore_testing_plan_input(RestoreTestingPlanName = RestoreTestingPlanName)
  output <- .backup$get_restore_testing_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_restore_testing_plan <- backup_get_restore_testing_plan

#' Returns RestoreTestingSelection, which displays resources and elements
#' of the restore testing plan
#'
#' @description
#' Returns RestoreTestingSelection, which displays resources and elements of the restore testing plan.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_get_restore_testing_selection/](https://www.paws-r-sdk.com/docs/backup_get_restore_testing_selection/) for full documentation.
#'
#' @param RestoreTestingPlanName &#91;required&#93; Required unique name of the restore testing plan.
#' @param RestoreTestingSelectionName &#91;required&#93; Required unique name of the restore testing selection.
#'
#' @keywords internal
#'
#' @rdname backup_get_restore_testing_selection
backup_get_restore_testing_selection <- function(RestoreTestingPlanName, RestoreTestingSelectionName) {
  op <- new_operation(
    name = "GetRestoreTestingSelection",
    http_method = "GET",
    http_path = "/restore-testing/plans/{RestoreTestingPlanName}/selections/{RestoreTestingSelectionName}",
    paginator = list()
  )
  input <- .backup$get_restore_testing_selection_input(RestoreTestingPlanName = RestoreTestingPlanName, RestoreTestingSelectionName = RestoreTestingSelectionName)
  output <- .backup$get_restore_testing_selection_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_restore_testing_selection <- backup_get_restore_testing_selection

#' Returns the Amazon Web Services resource types supported by Backup
#'
#' @description
#' Returns the Amazon Web Services resource types supported by Backup.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_get_supported_resource_types/](https://www.paws-r-sdk.com/docs/backup_get_supported_resource_types/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname backup_get_supported_resource_types
backup_get_supported_resource_types <- function() {
  op <- new_operation(
    name = "GetSupportedResourceTypes",
    http_method = "GET",
    http_path = "/supported-resource-types",
    paginator = list()
  )
  input <- .backup$get_supported_resource_types_input()
  output <- .backup$get_supported_resource_types_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$get_supported_resource_types <- backup_get_supported_resource_types

#' This is a request for a summary of backup jobs created or running within
#' the most recent 30 days
#'
#' @description
#' This is a request for a summary of backup jobs created or running within the most recent 30 days. You can include parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter results.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_backup_job_summaries/](https://www.paws-r-sdk.com/docs/backup_list_backup_job_summaries/) for full documentation.
#'
#' @param AccountId Returns the job count for the specified account.
#' 
#' If the request is sent from a member account or an account not part of
#' Amazon Web Services Organizations, jobs within requestor's account will
#' be returned.
#' 
#' Root, admin, and delegated administrator accounts can use the value ANY
#' to return job counts from every account in the organization.
#' 
#' `AGGREGATE_ALL` aggregates job counts from all accounts within the
#' authenticated organization, then returns the sum.
#' @param State This parameter returns the job count for jobs with the specified state.
#' 
#' The the value ANY returns count of all states.
#' 
#' `AGGREGATE_ALL` aggregates job counts for all states and returns the
#' sum.
#' @param ResourceType Returns the job count for the specified resource type. Use request
#' [`get_supported_resource_types`][backup_get_supported_resource_types] to
#' obtain strings for supported resource types.
#' 
#' The the value ANY returns count of all resource types.
#' 
#' `AGGREGATE_ALL` aggregates job counts for all resource types and returns
#' the sum.
#' 
#' The type of Amazon Web Services resource to be backed up; for example,
#' an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon
#' Relational Database Service (Amazon RDS) database.
#' @param MessageCategory This parameter returns the job count for the specified message category.
#' 
#' Example accepted strings include `AccessDenied`, `Success`, and
#' `InvalidParameters`. See
#' [Monitoring](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
#' for a list of accepted MessageCategory strings.
#' 
#' The the value ANY returns count of all message categories.
#' 
#' `AGGREGATE_ALL` aggregates job counts for all message categories and
#' returns the sum.
#' @param AggregationPeriod This is the period that sets the boundaries for returned results.
#' 
#' Acceptable values include
#' 
#' -   `ONE_DAY` for daily job count for the prior 14 days.
#' 
#' -   `SEVEN_DAYS` for the aggregated job count for the prior 7 days.
#' 
#' -   `FOURTEEN_DAYS` for aggregated job count for prior 14 days.
#' @param MaxResults This parameter sets the maximum number of items to be returned.
#' 
#' The value is an integer. Range of accepted values is from 1 to 500.
#' @param NextToken The next item following a partial list of returned resources. For
#' example, if a request is made to return `MaxResults` number of
#' resources, `NextToken` allows you to return more items in your list
#' starting at the location pointed to by the next token.
#'
#' @keywords internal
#'
#' @rdname backup_list_backup_job_summaries
backup_list_backup_job_summaries <- function(AccountId = NULL, State = NULL, ResourceType = NULL, MessageCategory = NULL, AggregationPeriod = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListBackupJobSummaries",
    http_method = "GET",
    http_path = "/audit/backup-job-summaries",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .backup$list_backup_job_summaries_input(AccountId = AccountId, State = State, ResourceType = ResourceType, MessageCategory = MessageCategory, AggregationPeriod = AggregationPeriod, MaxResults = MaxResults, NextToken = NextToken)
  output <- .backup$list_backup_job_summaries_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_backup_job_summaries <- backup_list_backup_job_summaries

#' Returns a list of existing backup jobs for an authenticated account for
#' the last 30 days
#'
#' @description
#' Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of time, consider using these [monitoring tools](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html).
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_backup_jobs/](https://www.paws-r-sdk.com/docs/backup_list_backup_jobs/) for full documentation.
#'
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#' @param ByResourceArn Returns only backup jobs that match the specified resource Amazon
#' Resource Name (ARN).
#' @param ByState Returns only backup jobs that are in the specified state.
#' @param ByBackupVaultName Returns only backup jobs that will be stored in the specified backup
#' vault. Backup vaults are identified by names that are unique to the
#' account used to create them and the Amazon Web Services Region where
#' they are created. They consist of lowercase letters, numbers, and
#' hyphens.
#' @param ByCreatedBefore Returns only backup jobs that were created before the specified date.
#' @param ByCreatedAfter Returns only backup jobs that were created after the specified date.
#' @param ByResourceType Returns only backup jobs for the specified resources:
#' 
#' -   `Aurora` for Amazon Aurora
#' 
#' -   `CloudFormation` for CloudFormation
#' 
#' -   `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
#' 
#' -   `DynamoDB` for Amazon DynamoDB
#' 
#' -   `EBS` for Amazon Elastic Block Store
#' 
#' -   `EC2` for Amazon Elastic Compute Cloud
#' 
#' -   `EFS` for Amazon Elastic File System
#' 
#' -   `FSx` for Amazon FSx
#' 
#' -   `Neptune` for Amazon Neptune
#' 
#' -   `Redshift` for Amazon Redshift
#' 
#' -   `RDS` for Amazon Relational Database Service
#' 
#' -   `SAP HANA on Amazon EC2` for SAP HANA databases
#' 
#' -   `Storage Gateway` for Storage Gateway
#' 
#' -   `S3` for Amazon S3
#' 
#' -   `Timestream` for Amazon Timestream
#' 
#' -   `VirtualMachine` for virtual machines
#' @param ByAccountId The account ID to list the jobs from. Returns only backup jobs
#' associated with the specified account ID.
#' 
#' If used from an Organizations management account, passing `*` returns
#' all jobs across the organization.
#' @param ByCompleteAfter Returns only backup jobs completed after a date expressed in Unix format
#' and Coordinated Universal Time (UTC).
#' @param ByCompleteBefore Returns only backup jobs completed before a date expressed in Unix
#' format and Coordinated Universal Time (UTC).
#' @param ByParentJobId This is a filter to list child (nested) jobs based on parent job ID.
#' @param ByMessageCategory This is an optional parameter that can be used to filter out jobs with a
#' MessageCategory which matches the value you input.
#' 
#' Example strings may include `AccessDenied`, `SUCCESS`, `AGGREGATE_ALL`,
#' and `InvalidParameters`.
#' 
#' View
#' [Monitoring](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
#' 
#' The wildcard () returns count of all message categories.
#' 
#' `AGGREGATE_ALL` aggregates job counts for all message categories and
#' returns the sum.
#'
#' @keywords internal
#'
#' @rdname backup_list_backup_jobs
backup_list_backup_jobs <- function(NextToken = NULL, MaxResults = NULL, ByResourceArn = NULL, ByState = NULL, ByBackupVaultName = NULL, ByCreatedBefore = NULL, ByCreatedAfter = NULL, ByResourceType = NULL, ByAccountId = NULL, ByCompleteAfter = NULL, ByCompleteBefore = NULL, ByParentJobId = NULL, ByMessageCategory = NULL) {
  op <- new_operation(
    name = "ListBackupJobs",
    http_method = "GET",
    http_path = "/backup-jobs/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "BackupJobs")
  )
  input <- .backup$list_backup_jobs_input(NextToken = NextToken, MaxResults = MaxResults, ByResourceArn = ByResourceArn, ByState = ByState, ByBackupVaultName = ByBackupVaultName, ByCreatedBefore = ByCreatedBefore, ByCreatedAfter = ByCreatedAfter, ByResourceType = ByResourceType, ByAccountId = ByAccountId, ByCompleteAfter = ByCompleteAfter, ByCompleteBefore = ByCompleteBefore, ByParentJobId = ByParentJobId, ByMessageCategory = ByMessageCategory)
  output <- .backup$list_backup_jobs_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_backup_jobs <- backup_list_backup_jobs

#' Returns metadata of your saved backup plan templates, including the
#' template ID, name, and the creation and deletion dates
#'
#' @description
#' Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and deletion dates.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_backup_plan_templates/](https://www.paws-r-sdk.com/docs/backup_list_backup_plan_templates/) for full documentation.
#'
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @keywords internal
#'
#' @rdname backup_list_backup_plan_templates
backup_list_backup_plan_templates <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListBackupPlanTemplates",
    http_method = "GET",
    http_path = "/backup/template/plans",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "BackupPlanTemplatesList")
  )
  input <- .backup$list_backup_plan_templates_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_backup_plan_templates_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_backup_plan_templates <- backup_list_backup_plan_templates

#' Returns version metadata of your backup plans, including Amazon Resource
#' Names (ARNs), backup plan IDs, creation and deletion dates, plan names,
#' and version IDs
#'
#' @description
#' Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation and deletion dates, plan names, and version IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_backup_plan_versions/](https://www.paws-r-sdk.com/docs/backup_list_backup_plan_versions/) for full documentation.
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @keywords internal
#'
#' @rdname backup_list_backup_plan_versions
backup_list_backup_plan_versions <- function(BackupPlanId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListBackupPlanVersions",
    http_method = "GET",
    http_path = "/backup/plans/{backupPlanId}/versions/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "BackupPlanVersionsList")
  )
  input <- .backup$list_backup_plan_versions_input(BackupPlanId = BackupPlanId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_backup_plan_versions_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_backup_plan_versions <- backup_list_backup_plan_versions

#' Returns a list of all active backup plans for an authenticated account
#'
#' @description
#' Returns a list of all active backup plans for an authenticated account. The list contains information such as Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_backup_plans/](https://www.paws-r-sdk.com/docs/backup_list_backup_plans/) for full documentation.
#'
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#' @param IncludeDeleted A Boolean value with a default value of `FALSE` that returns deleted
#' backup plans when set to `TRUE`.
#'
#' @keywords internal
#'
#' @rdname backup_list_backup_plans
backup_list_backup_plans <- function(NextToken = NULL, MaxResults = NULL, IncludeDeleted = NULL) {
  op <- new_operation(
    name = "ListBackupPlans",
    http_method = "GET",
    http_path = "/backup/plans/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "BackupPlansList")
  )
  input <- .backup$list_backup_plans_input(NextToken = NextToken, MaxResults = MaxResults, IncludeDeleted = IncludeDeleted)
  output <- .backup$list_backup_plans_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_backup_plans <- backup_list_backup_plans

#' Returns an array containing metadata of the resources associated with
#' the target backup plan
#'
#' @description
#' Returns an array containing metadata of the resources associated with the target backup plan.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_backup_selections/](https://www.paws-r-sdk.com/docs/backup_list_backup_selections/) for full documentation.
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @keywords internal
#'
#' @rdname backup_list_backup_selections
backup_list_backup_selections <- function(BackupPlanId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListBackupSelections",
    http_method = "GET",
    http_path = "/backup/plans/{backupPlanId}/selections/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "BackupSelectionsList")
  )
  input <- .backup$list_backup_selections_input(BackupPlanId = BackupPlanId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_backup_selections_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_backup_selections <- backup_list_backup_selections

#' Returns a list of recovery point storage containers along with
#' information about them
#'
#' @description
#' Returns a list of recovery point storage containers along with information about them.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_backup_vaults/](https://www.paws-r-sdk.com/docs/backup_list_backup_vaults/) for full documentation.
#'
#' @param ByVaultType This parameter will sort the list of vaults by vault type.
#' @param ByShared This parameter will sort the list of vaults by shared vaults.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @keywords internal
#'
#' @rdname backup_list_backup_vaults
backup_list_backup_vaults <- function(ByVaultType = NULL, ByShared = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListBackupVaults",
    http_method = "GET",
    http_path = "/backup-vaults/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "BackupVaultList")
  )
  input <- .backup$list_backup_vaults_input(ByVaultType = ByVaultType, ByShared = ByShared, NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_backup_vaults_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_backup_vaults <- backup_list_backup_vaults

#' This request obtains a list of copy jobs created or running within the
#' the most recent 30 days
#'
#' @description
#' This request obtains a list of copy jobs created or running within the the most recent 30 days. You can include parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter results.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_copy_job_summaries/](https://www.paws-r-sdk.com/docs/backup_list_copy_job_summaries/) for full documentation.
#'
#' @param AccountId Returns the job count for the specified account.
#' 
#' If the request is sent from a member account or an account not part of
#' Amazon Web Services Organizations, jobs within requestor's account will
#' be returned.
#' 
#' Root, admin, and delegated administrator accounts can use the value ANY
#' to return job counts from every account in the organization.
#' 
#' `AGGREGATE_ALL` aggregates job counts from all accounts within the
#' authenticated organization, then returns the sum.
#' @param State This parameter returns the job count for jobs with the specified state.
#' 
#' The the value ANY returns count of all states.
#' 
#' `AGGREGATE_ALL` aggregates job counts for all states and returns the
#' sum.
#' @param ResourceType Returns the job count for the specified resource type. Use request
#' [`get_supported_resource_types`][backup_get_supported_resource_types] to
#' obtain strings for supported resource types.
#' 
#' The the value ANY returns count of all resource types.
#' 
#' `AGGREGATE_ALL` aggregates job counts for all resource types and returns
#' the sum.
#' 
#' The type of Amazon Web Services resource to be backed up; for example,
#' an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon
#' Relational Database Service (Amazon RDS) database.
#' @param MessageCategory This parameter returns the job count for the specified message category.
#' 
#' Example accepted strings include `AccessDenied`, `Success`, and
#' `InvalidParameters`. See
#' [Monitoring](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
#' for a list of accepted MessageCategory strings.
#' 
#' The the value ANY returns count of all message categories.
#' 
#' `AGGREGATE_ALL` aggregates job counts for all message categories and
#' returns the sum.
#' @param AggregationPeriod This is the period that sets the boundaries for returned results.
#' 
#' -   `ONE_DAY` for daily job count for the prior 14 days.
#' 
#' -   `SEVEN_DAYS` for the aggregated job count for the prior 7 days.
#' 
#' -   `FOURTEEN_DAYS` for aggregated job count for prior 14 days.
#' @param MaxResults This parameter sets the maximum number of items to be returned.
#' 
#' The value is an integer. Range of accepted values is from 1 to 500.
#' @param NextToken The next item following a partial list of returned resources. For
#' example, if a request is made to return `MaxResults` number of
#' resources, `NextToken` allows you to return more items in your list
#' starting at the location pointed to by the next token.
#'
#' @keywords internal
#'
#' @rdname backup_list_copy_job_summaries
backup_list_copy_job_summaries <- function(AccountId = NULL, State = NULL, ResourceType = NULL, MessageCategory = NULL, AggregationPeriod = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCopyJobSummaries",
    http_method = "GET",
    http_path = "/audit/copy-job-summaries",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .backup$list_copy_job_summaries_input(AccountId = AccountId, State = State, ResourceType = ResourceType, MessageCategory = MessageCategory, AggregationPeriod = AggregationPeriod, MaxResults = MaxResults, NextToken = NextToken)
  output <- .backup$list_copy_job_summaries_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_copy_job_summaries <- backup_list_copy_job_summaries

#' Returns metadata about your copy jobs
#'
#' @description
#' Returns metadata about your copy jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_copy_jobs/](https://www.paws-r-sdk.com/docs/backup_list_copy_jobs/) for full documentation.
#'
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return MaxResults number of items, NextToken
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#' @param ByResourceArn Returns only copy jobs that match the specified resource Amazon Resource
#' Name (ARN).
#' @param ByState Returns only copy jobs that are in the specified state.
#' @param ByCreatedBefore Returns only copy jobs that were created before the specified date.
#' @param ByCreatedAfter Returns only copy jobs that were created after the specified date.
#' @param ByResourceType Returns only backup jobs for the specified resources:
#' 
#' -   `Aurora` for Amazon Aurora
#' 
#' -   `CloudFormation` for CloudFormation
#' 
#' -   `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
#' 
#' -   `DynamoDB` for Amazon DynamoDB
#' 
#' -   `EBS` for Amazon Elastic Block Store
#' 
#' -   `EC2` for Amazon Elastic Compute Cloud
#' 
#' -   `EFS` for Amazon Elastic File System
#' 
#' -   `FSx` for Amazon FSx
#' 
#' -   `Neptune` for Amazon Neptune
#' 
#' -   `Redshift` for Amazon Redshift
#' 
#' -   `RDS` for Amazon Relational Database Service
#' 
#' -   `SAP HANA on Amazon EC2` for SAP HANA databases
#' 
#' -   `Storage Gateway` for Storage Gateway
#' 
#' -   `S3` for Amazon S3
#' 
#' -   `Timestream` for Amazon Timestream
#' 
#' -   `VirtualMachine` for virtual machines
#' @param ByDestinationVaultArn An Amazon Resource Name (ARN) that uniquely identifies a source backup
#' vault to copy from; for example,
#' `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
#' @param ByAccountId The account ID to list the jobs from. Returns only copy jobs associated
#' with the specified account ID.
#' @param ByCompleteBefore Returns only copy jobs completed before a date expressed in Unix format
#' and Coordinated Universal Time (UTC).
#' @param ByCompleteAfter Returns only copy jobs completed after a date expressed in Unix format
#' and Coordinated Universal Time (UTC).
#' @param ByParentJobId This is a filter to list child (nested) jobs based on parent job ID.
#' @param ByMessageCategory This is an optional parameter that can be used to filter out jobs with a
#' MessageCategory which matches the value you input.
#' 
#' Example strings may include `AccessDenied`, `SUCCESS`, `AGGREGATE_ALL`,
#' and `INVALIDPARAMETERS`.
#' 
#' View
#' [Monitoring](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
#' for a list of accepted strings.
#' 
#' The the value ANY returns count of all message categories.
#' 
#' `AGGREGATE_ALL` aggregates job counts for all message categories and
#' returns the sum.
#'
#' @keywords internal
#'
#' @rdname backup_list_copy_jobs
backup_list_copy_jobs <- function(NextToken = NULL, MaxResults = NULL, ByResourceArn = NULL, ByState = NULL, ByCreatedBefore = NULL, ByCreatedAfter = NULL, ByResourceType = NULL, ByDestinationVaultArn = NULL, ByAccountId = NULL, ByCompleteBefore = NULL, ByCompleteAfter = NULL, ByParentJobId = NULL, ByMessageCategory = NULL) {
  op <- new_operation(
    name = "ListCopyJobs",
    http_method = "GET",
    http_path = "/copy-jobs/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "CopyJobs")
  )
  input <- .backup$list_copy_jobs_input(NextToken = NextToken, MaxResults = MaxResults, ByResourceArn = ByResourceArn, ByState = ByState, ByCreatedBefore = ByCreatedBefore, ByCreatedAfter = ByCreatedAfter, ByResourceType = ByResourceType, ByDestinationVaultArn = ByDestinationVaultArn, ByAccountId = ByAccountId, ByCompleteBefore = ByCompleteBefore, ByCompleteAfter = ByCompleteAfter, ByParentJobId = ByParentJobId, ByMessageCategory = ByMessageCategory)
  output <- .backup$list_copy_jobs_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_copy_jobs <- backup_list_copy_jobs

#' Returns a list of all frameworks for an Amazon Web Services account and
#' Amazon Web Services Region
#'
#' @description
#' Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_frameworks/](https://www.paws-r-sdk.com/docs/backup_list_frameworks/) for full documentation.
#'
#' @param MaxResults The number of desired results from 1 to 1000. Optional. If unspecified,
#' the query will return 1 MB of data.
#' @param NextToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#'
#' @keywords internal
#'
#' @rdname backup_list_frameworks
backup_list_frameworks <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListFrameworks",
    http_method = "GET",
    http_path = "/audit/frameworks",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .backup$list_frameworks_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .backup$list_frameworks_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_frameworks <- backup_list_frameworks

#' This action returns metadata about active and previous legal holds
#'
#' @description
#' This action returns metadata about active and previous legal holds.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_legal_holds/](https://www.paws-r-sdk.com/docs/backup_list_legal_holds/) for full documentation.
#'
#' @param NextToken The next item following a partial list of returned resources. For
#' example, if a request is made to return `MaxResults` number of
#' resources, `NextToken` allows you to return more items in your list
#' starting at the location pointed to by the next token.
#' @param MaxResults The maximum number of resource list items to be returned.
#'
#' @keywords internal
#'
#' @rdname backup_list_legal_holds
backup_list_legal_holds <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListLegalHolds",
    http_method = "GET",
    http_path = "/legal-holds/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "LegalHolds")
  )
  input <- .backup$list_legal_holds_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_legal_holds_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_legal_holds <- backup_list_legal_holds

#' Returns an array of resources successfully backed up by Backup,
#' including the time the resource was saved, an Amazon Resource Name (ARN)
#' of the resource, and a resource type
#'
#' @description
#' Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_protected_resources/](https://www.paws-r-sdk.com/docs/backup_list_protected_resources/) for full documentation.
#'
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @keywords internal
#'
#' @rdname backup_list_protected_resources
backup_list_protected_resources <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListProtectedResources",
    http_method = "GET",
    http_path = "/resources/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Results")
  )
  input <- .backup$list_protected_resources_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_protected_resources_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_protected_resources <- backup_list_protected_resources

#' This request lists the protected resources corresponding to each backup
#' vault
#'
#' @description
#' This request lists the protected resources corresponding to each backup vault.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_protected_resources_by_backup_vault/](https://www.paws-r-sdk.com/docs/backup_list_protected_resources_by_backup_vault/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; This is the list of protected resources by backup vault within the
#' vault(s) you specify by name.
#' @param BackupVaultAccountId This is the list of protected resources by backup vault within the
#' vault(s) you specify by account ID.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @keywords internal
#'
#' @rdname backup_list_protected_resources_by_backup_vault
backup_list_protected_resources_by_backup_vault <- function(BackupVaultName, BackupVaultAccountId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListProtectedResourcesByBackupVault",
    http_method = "GET",
    http_path = "/backup-vaults/{backupVaultName}/resources/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Results")
  )
  input <- .backup$list_protected_resources_by_backup_vault_input(BackupVaultName = BackupVaultName, BackupVaultAccountId = BackupVaultAccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_protected_resources_by_backup_vault_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_protected_resources_by_backup_vault <- backup_list_protected_resources_by_backup_vault

#' Returns detailed information about the recovery points stored in a
#' backup vault
#'
#' @description
#' Returns detailed information about the recovery points stored in a backup vault.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_recovery_points_by_backup_vault/](https://www.paws-r-sdk.com/docs/backup_list_recovery_points_by_backup_vault/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web Services Region where they are created. They
#' consist of lowercase letters, numbers, and hyphens.
#' 
#' Backup vault name might not be available when a supported service
#' creates the backup.
#' @param BackupVaultAccountId This parameter will sort the list of recovery points by account ID.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#' @param ByResourceArn Returns only recovery points that match the specified resource Amazon
#' Resource Name (ARN).
#' @param ByResourceType Returns only recovery points that match the specified resource type(s):
#' 
#' -   `Aurora` for Amazon Aurora
#' 
#' -   `CloudFormation` for CloudFormation
#' 
#' -   `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
#' 
#' -   `DynamoDB` for Amazon DynamoDB
#' 
#' -   `EBS` for Amazon Elastic Block Store
#' 
#' -   `EC2` for Amazon Elastic Compute Cloud
#' 
#' -   `EFS` for Amazon Elastic File System
#' 
#' -   `FSx` for Amazon FSx
#' 
#' -   `Neptune` for Amazon Neptune
#' 
#' -   `Redshift` for Amazon Redshift
#' 
#' -   `RDS` for Amazon Relational Database Service
#' 
#' -   `SAP HANA on Amazon EC2` for SAP HANA databases
#' 
#' -   `Storage Gateway` for Storage Gateway
#' 
#' -   `S3` for Amazon S3
#' 
#' -   `Timestream` for Amazon Timestream
#' 
#' -   `VirtualMachine` for virtual machines
#' @param ByBackupPlanId Returns only recovery points that match the specified backup plan ID.
#' @param ByCreatedBefore Returns only recovery points that were created before the specified
#' timestamp.
#' @param ByCreatedAfter Returns only recovery points that were created after the specified
#' timestamp.
#' @param ByParentRecoveryPointArn This returns only recovery points that match the specified parent
#' (composite) recovery point Amazon Resource Name (ARN).
#'
#' @keywords internal
#'
#' @rdname backup_list_recovery_points_by_backup_vault
backup_list_recovery_points_by_backup_vault <- function(BackupVaultName, BackupVaultAccountId = NULL, NextToken = NULL, MaxResults = NULL, ByResourceArn = NULL, ByResourceType = NULL, ByBackupPlanId = NULL, ByCreatedBefore = NULL, ByCreatedAfter = NULL, ByParentRecoveryPointArn = NULL) {
  op <- new_operation(
    name = "ListRecoveryPointsByBackupVault",
    http_method = "GET",
    http_path = "/backup-vaults/{backupVaultName}/recovery-points/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RecoveryPoints")
  )
  input <- .backup$list_recovery_points_by_backup_vault_input(BackupVaultName = BackupVaultName, BackupVaultAccountId = BackupVaultAccountId, NextToken = NextToken, MaxResults = MaxResults, ByResourceArn = ByResourceArn, ByResourceType = ByResourceType, ByBackupPlanId = ByBackupPlanId, ByCreatedBefore = ByCreatedBefore, ByCreatedAfter = ByCreatedAfter, ByParentRecoveryPointArn = ByParentRecoveryPointArn)
  output <- .backup$list_recovery_points_by_backup_vault_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_recovery_points_by_backup_vault <- backup_list_recovery_points_by_backup_vault

#' This action returns recovery point ARNs (Amazon Resource Names) of the
#' specified legal hold
#'
#' @description
#' This action returns recovery point ARNs (Amazon Resource Names) of the specified legal hold.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_recovery_points_by_legal_hold/](https://www.paws-r-sdk.com/docs/backup_list_recovery_points_by_legal_hold/) for full documentation.
#'
#' @param LegalHoldId &#91;required&#93; This is the ID of the legal hold.
#' @param NextToken This is the next item following a partial list of returned resources.
#' For example, if a request is made to return `MaxResults` number of
#' resources, `NextToken` allows you to return more items in your list
#' starting at the location pointed to by the next token.
#' @param MaxResults This is the maximum number of resource list items to be returned.
#'
#' @keywords internal
#'
#' @rdname backup_list_recovery_points_by_legal_hold
backup_list_recovery_points_by_legal_hold <- function(LegalHoldId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRecoveryPointsByLegalHold",
    http_method = "GET",
    http_path = "/legal-holds/{legalHoldId}/recovery-points",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RecoveryPoints")
  )
  input <- .backup$list_recovery_points_by_legal_hold_input(LegalHoldId = LegalHoldId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_recovery_points_by_legal_hold_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_recovery_points_by_legal_hold <- backup_list_recovery_points_by_legal_hold

#' Returns detailed information about all the recovery points of the type
#' specified by a resource Amazon Resource Name (ARN)
#'
#' @description
#' Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_recovery_points_by_resource/](https://www.paws-r-sdk.com/docs/backup_list_recovery_points_by_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; An ARN that uniquely identifies a resource. The format of the ARN
#' depends on the resource type.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#' 
#' Amazon RDS requires a value of at least 20.
#'
#' @keywords internal
#'
#' @rdname backup_list_recovery_points_by_resource
backup_list_recovery_points_by_resource <- function(ResourceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRecoveryPointsByResource",
    http_method = "GET",
    http_path = "/resources/{resourceArn}/recovery-points/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RecoveryPoints")
  )
  input <- .backup$list_recovery_points_by_resource_input(ResourceArn = ResourceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_recovery_points_by_resource_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_recovery_points_by_resource <- backup_list_recovery_points_by_resource

#' Returns details about your report jobs
#'
#' @description
#' Returns details about your report jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_report_jobs/](https://www.paws-r-sdk.com/docs/backup_list_report_jobs/) for full documentation.
#'
#' @param ByReportPlanName Returns only report jobs with the specified report plan name.
#' @param ByCreationBefore Returns only report jobs that were created before the date and time
#' specified in Unix format and Coordinated Universal Time (UTC). For
#' example, the value 1516925490 represents Friday, January 26, 2018
#' 12:11:30 AM.
#' @param ByCreationAfter Returns only report jobs that were created after the date and time
#' specified in Unix format and Coordinated Universal Time (UTC). For
#' example, the value 1516925490 represents Friday, January 26, 2018
#' 12:11:30 AM.
#' @param ByStatus Returns only report jobs that are in the specified status. The statuses
#' are:
#' 
#' `CREATED | RUNNING | COMPLETED | FAILED`
#' @param MaxResults The number of desired results from 1 to 1000. Optional. If unspecified,
#' the query will return 1 MB of data.
#' @param NextToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#'
#' @keywords internal
#'
#' @rdname backup_list_report_jobs
backup_list_report_jobs <- function(ByReportPlanName = NULL, ByCreationBefore = NULL, ByCreationAfter = NULL, ByStatus = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListReportJobs",
    http_method = "GET",
    http_path = "/audit/report-jobs",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .backup$list_report_jobs_input(ByReportPlanName = ByReportPlanName, ByCreationBefore = ByCreationBefore, ByCreationAfter = ByCreationAfter, ByStatus = ByStatus, MaxResults = MaxResults, NextToken = NextToken)
  output <- .backup$list_report_jobs_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_report_jobs <- backup_list_report_jobs

#' Returns a list of your report plans
#'
#' @description
#' Returns a list of your report plans. For detailed information about a single report plan, use [`describe_report_plan`][backup_describe_report_plan].
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_report_plans/](https://www.paws-r-sdk.com/docs/backup_list_report_plans/) for full documentation.
#'
#' @param MaxResults The number of desired results from 1 to 1000. Optional. If unspecified,
#' the query will return 1 MB of data.
#' @param NextToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#'
#' @keywords internal
#'
#' @rdname backup_list_report_plans
backup_list_report_plans <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListReportPlans",
    http_method = "GET",
    http_path = "/audit/report-plans",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .backup$list_report_plans_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .backup$list_report_plans_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_report_plans <- backup_list_report_plans

#' This request obtains a summary of restore jobs created or running within
#' the the most recent 30 days
#'
#' @description
#' This request obtains a summary of restore jobs created or running within the the most recent 30 days. You can include parameters AccountID, State, ResourceType, AggregationPeriod, MaxResults, or NextToken to filter results.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_restore_job_summaries/](https://www.paws-r-sdk.com/docs/backup_list_restore_job_summaries/) for full documentation.
#'
#' @param AccountId Returns the job count for the specified account.
#' 
#' If the request is sent from a member account or an account not part of
#' Amazon Web Services Organizations, jobs within requestor's account will
#' be returned.
#' 
#' Root, admin, and delegated administrator accounts can use the value ANY
#' to return job counts from every account in the organization.
#' 
#' `AGGREGATE_ALL` aggregates job counts from all accounts within the
#' authenticated organization, then returns the sum.
#' @param State This parameter returns the job count for jobs with the specified state.
#' 
#' The the value ANY returns count of all states.
#' 
#' `AGGREGATE_ALL` aggregates job counts for all states and returns the
#' sum.
#' @param ResourceType Returns the job count for the specified resource type. Use request
#' [`get_supported_resource_types`][backup_get_supported_resource_types] to
#' obtain strings for supported resource types.
#' 
#' The the value ANY returns count of all resource types.
#' 
#' `AGGREGATE_ALL` aggregates job counts for all resource types and returns
#' the sum.
#' 
#' The type of Amazon Web Services resource to be backed up; for example,
#' an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon
#' Relational Database Service (Amazon RDS) database.
#' @param AggregationPeriod This is the period that sets the boundaries for returned results.
#' 
#' Acceptable values include
#' 
#' -   `ONE_DAY` for daily job count for the prior 14 days.
#' 
#' -   `SEVEN_DAYS` for the aggregated job count for the prior 7 days.
#' 
#' -   `FOURTEEN_DAYS` for aggregated job count for prior 14 days.
#' @param MaxResults This parameter sets the maximum number of items to be returned.
#' 
#' The value is an integer. Range of accepted values is from 1 to 500.
#' @param NextToken The next item following a partial list of returned resources. For
#' example, if a request is made to return `MaxResults` number of
#' resources, `NextToken` allows you to return more items in your list
#' starting at the location pointed to by the next token.
#'
#' @keywords internal
#'
#' @rdname backup_list_restore_job_summaries
backup_list_restore_job_summaries <- function(AccountId = NULL, State = NULL, ResourceType = NULL, AggregationPeriod = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListRestoreJobSummaries",
    http_method = "GET",
    http_path = "/audit/restore-job-summaries",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .backup$list_restore_job_summaries_input(AccountId = AccountId, State = State, ResourceType = ResourceType, AggregationPeriod = AggregationPeriod, MaxResults = MaxResults, NextToken = NextToken)
  output <- .backup$list_restore_job_summaries_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_restore_job_summaries <- backup_list_restore_job_summaries

#' Returns a list of jobs that Backup initiated to restore a saved
#' resource, including details about the recovery process
#'
#' @description
#' Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery process.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_restore_jobs/](https://www.paws-r-sdk.com/docs/backup_list_restore_jobs/) for full documentation.
#'
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#' @param ByAccountId The account ID to list the jobs from. Returns only restore jobs
#' associated with the specified account ID.
#' @param ByResourceType Include this parameter to return only restore jobs for the specified
#' resources:
#' 
#' -   `Aurora` for Amazon Aurora
#' 
#' -   `CloudFormation` for CloudFormation
#' 
#' -   `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
#' 
#' -   `DynamoDB` for Amazon DynamoDB
#' 
#' -   `EBS` for Amazon Elastic Block Store
#' 
#' -   `EC2` for Amazon Elastic Compute Cloud
#' 
#' -   `EFS` for Amazon Elastic File System
#' 
#' -   `FSx` for Amazon FSx
#' 
#' -   `Neptune` for Amazon Neptune
#' 
#' -   `Redshift` for Amazon Redshift
#' 
#' -   `RDS` for Amazon Relational Database Service
#' 
#' -   `SAP HANA on Amazon EC2` for SAP HANA databases
#' 
#' -   `Storage Gateway` for Storage Gateway
#' 
#' -   `S3` for Amazon S3
#' 
#' -   `Timestream` for Amazon Timestream
#' 
#' -   `VirtualMachine` for virtual machines
#' @param ByCreatedBefore Returns only restore jobs that were created before the specified date.
#' @param ByCreatedAfter Returns only restore jobs that were created after the specified date.
#' @param ByStatus Returns only restore jobs associated with the specified job status.
#' @param ByCompleteBefore Returns only copy jobs completed before a date expressed in Unix format
#' and Coordinated Universal Time (UTC).
#' @param ByCompleteAfter Returns only copy jobs completed after a date expressed in Unix format
#' and Coordinated Universal Time (UTC).
#' @param ByRestoreTestingPlanArn This returns only restore testing jobs that match the specified resource
#' Amazon Resource Name (ARN).
#'
#' @keywords internal
#'
#' @rdname backup_list_restore_jobs
backup_list_restore_jobs <- function(NextToken = NULL, MaxResults = NULL, ByAccountId = NULL, ByResourceType = NULL, ByCreatedBefore = NULL, ByCreatedAfter = NULL, ByStatus = NULL, ByCompleteBefore = NULL, ByCompleteAfter = NULL, ByRestoreTestingPlanArn = NULL) {
  op <- new_operation(
    name = "ListRestoreJobs",
    http_method = "GET",
    http_path = "/restore-jobs/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RestoreJobs")
  )
  input <- .backup$list_restore_jobs_input(NextToken = NextToken, MaxResults = MaxResults, ByAccountId = ByAccountId, ByResourceType = ByResourceType, ByCreatedBefore = ByCreatedBefore, ByCreatedAfter = ByCreatedAfter, ByStatus = ByStatus, ByCompleteBefore = ByCompleteBefore, ByCompleteAfter = ByCompleteAfter, ByRestoreTestingPlanArn = ByRestoreTestingPlanArn)
  output <- .backup$list_restore_jobs_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_restore_jobs <- backup_list_restore_jobs

#' This returns restore jobs that contain the specified protected resource
#'
#' @description
#' This returns restore jobs that contain the specified protected resource.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_restore_jobs_by_protected_resource/](https://www.paws-r-sdk.com/docs/backup_list_restore_jobs_by_protected_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; Returns only restore jobs that match the specified resource Amazon
#' Resource Name (ARN).
#' @param ByStatus Returns only restore jobs associated with the specified job status.
#' @param ByRecoveryPointCreationDateAfter Returns only restore jobs of recovery points that were created after the
#' specified date.
#' @param ByRecoveryPointCreationDateBefore Returns only restore jobs of recovery points that were created before
#' the specified date.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request ismade to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @keywords internal
#'
#' @rdname backup_list_restore_jobs_by_protected_resource
backup_list_restore_jobs_by_protected_resource <- function(ResourceArn, ByStatus = NULL, ByRecoveryPointCreationDateAfter = NULL, ByRecoveryPointCreationDateBefore = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRestoreJobsByProtectedResource",
    http_method = "GET",
    http_path = "/resources/{resourceArn}/restore-jobs/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RestoreJobs")
  )
  input <- .backup$list_restore_jobs_by_protected_resource_input(ResourceArn = ResourceArn, ByStatus = ByStatus, ByRecoveryPointCreationDateAfter = ByRecoveryPointCreationDateAfter, ByRecoveryPointCreationDateBefore = ByRecoveryPointCreationDateBefore, NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_restore_jobs_by_protected_resource_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_restore_jobs_by_protected_resource <- backup_list_restore_jobs_by_protected_resource

#' Returns a list of restore testing plans
#'
#' @description
#' Returns a list of restore testing plans.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_restore_testing_plans/](https://www.paws-r-sdk.com/docs/backup_list_restore_testing_plans/) for full documentation.
#'
#' @param MaxResults The maximum number of items to be returned.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the nexttoken.
#'
#' @keywords internal
#'
#' @rdname backup_list_restore_testing_plans
backup_list_restore_testing_plans <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListRestoreTestingPlans",
    http_method = "GET",
    http_path = "/restore-testing/plans",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RestoreTestingPlans")
  )
  input <- .backup$list_restore_testing_plans_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .backup$list_restore_testing_plans_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_restore_testing_plans <- backup_list_restore_testing_plans

#' Returns a list of restore testing selections
#'
#' @description
#' Returns a list of restore testing selections. Can be filtered by `MaxResults` and `RestoreTestingPlanName`.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_restore_testing_selections/](https://www.paws-r-sdk.com/docs/backup_list_restore_testing_selections/) for full documentation.
#'
#' @param MaxResults The maximum number of items to be returned.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the nexttoken.
#' @param RestoreTestingPlanName &#91;required&#93; Returns restore testing selections by the specified restore testing plan
#' name.
#'
#' @keywords internal
#'
#' @rdname backup_list_restore_testing_selections
backup_list_restore_testing_selections <- function(MaxResults = NULL, NextToken = NULL, RestoreTestingPlanName) {
  op <- new_operation(
    name = "ListRestoreTestingSelections",
    http_method = "GET",
    http_path = "/restore-testing/plans/{RestoreTestingPlanName}/selections",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "RestoreTestingSelections")
  )
  input <- .backup$list_restore_testing_selections_input(MaxResults = MaxResults, NextToken = NextToken, RestoreTestingPlanName = RestoreTestingPlanName)
  output <- .backup$list_restore_testing_selections_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_restore_testing_selections <- backup_list_restore_testing_selections

#' Returns a list of key-value pairs assigned to a target recovery point,
#' backup plan, or backup vault
#'
#' @description
#' Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_list_tags/](https://www.paws-r-sdk.com/docs/backup_list_tags/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a resource. The
#' format of the ARN depends on the type of resource. Valid targets for
#' [`list_tags`][backup_list_tags] are recovery points, backup plans, and
#' backup vaults.
#' @param NextToken The next item following a partial list of returned items. For example,
#' if a request is made to return `MaxResults` number of items, `NextToken`
#' allows you to return more items in your list starting at the location
#' pointed to by the next token.
#' @param MaxResults The maximum number of items to be returned.
#'
#' @keywords internal
#'
#' @rdname backup_list_tags
backup_list_tags <- function(ResourceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "GET",
    http_path = "/tags/{resourceArn}/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .backup$list_tags_input(ResourceArn = ResourceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .backup$list_tags_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$list_tags <- backup_list_tags

#' Sets a resource-based policy that is used to manage access permissions
#' on the target backup vault
#'
#' @description
#' Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a backup vault name and an access policy document in JSON format.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_put_backup_vault_access_policy/](https://www.paws-r-sdk.com/docs/backup_put_backup_vault_access_policy/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web Services Region where they are created. They
#' consist of lowercase letters, numbers, and hyphens.
#' @param Policy The backup vault access policy document in JSON format.
#'
#' @keywords internal
#'
#' @rdname backup_put_backup_vault_access_policy
backup_put_backup_vault_access_policy <- function(BackupVaultName, Policy = NULL) {
  op <- new_operation(
    name = "PutBackupVaultAccessPolicy",
    http_method = "PUT",
    http_path = "/backup-vaults/{backupVaultName}/access-policy",
    paginator = list()
  )
  input <- .backup$put_backup_vault_access_policy_input(BackupVaultName = BackupVaultName, Policy = Policy)
  output <- .backup$put_backup_vault_access_policy_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$put_backup_vault_access_policy <- backup_put_backup_vault_access_policy

#' Applies Backup Vault Lock to a backup vault, preventing attempts to
#' delete any recovery point stored in or created in a backup vault
#'
#' @description
#' Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a minimum and maximum retention period for future backup and copy jobs that target a backup vault.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_put_backup_vault_lock_configuration/](https://www.paws-r-sdk.com/docs/backup_put_backup_vault_lock_configuration/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The Backup Vault Lock configuration that specifies the name of the
#' backup vault it protects.
#' @param MinRetentionDays The Backup Vault Lock configuration that specifies the minimum retention
#' period that the vault retains its recovery points. This setting can be
#' useful if, for example, your organization's policies require you to
#' retain certain data for at least seven years (2555 days).
#' 
#' If this parameter is not specified, Vault Lock will not enforce a
#' minimum retention period.
#' 
#' If this parameter is specified, any backup or copy job to the vault must
#' have a lifecycle policy with a retention period equal to or longer than
#' the minimum retention period. If the job's retention period is shorter
#' than that minimum retention period, then the vault fails that backup or
#' copy job, and you should either modify your lifecycle settings or use a
#' different vault. The shortest minimum retention period you can specify
#' is 1 day. Recovery points already saved in the vault prior to Vault Lock
#' are not affected.
#' @param MaxRetentionDays The Backup Vault Lock configuration that specifies the maximum retention
#' period that the vault retains its recovery points. This setting can be
#' useful if, for example, your organization's policies require you to
#' destroy certain data after retaining it for four years (1460 days).
#' 
#' If this parameter is not included, Vault Lock does not enforce a maximum
#' retention period on the recovery points in the vault. If this parameter
#' is included without a value, Vault Lock will not enforce a maximum
#' retention period.
#' 
#' If this parameter is specified, any backup or copy job to the vault must
#' have a lifecycle policy with a retention period equal to or shorter than
#' the maximum retention period. If the job's retention period is longer
#' than that maximum retention period, then the vault fails the backup or
#' copy job, and you should either modify your lifecycle settings or use a
#' different vault. The longest maximum retention period you can specify is
#' 36500 days (approximately 100 years). Recovery points already saved in
#' the vault prior to Vault Lock are not affected.
#' @param ChangeableForDays The Backup Vault Lock configuration that specifies the number of days
#' before the lock date. For example, setting `ChangeableForDays` to 30 on
#' Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm
#' UTC.
#' 
#' Backup enforces a 72-hour cooling-off period before Vault Lock takes
#' effect and becomes immutable. Therefore, you must set
#' `ChangeableForDays` to 3 or greater.
#' 
#' Before the lock date, you can delete Vault Lock from the vault using
#' [`delete_backup_vault_lock_configuration`][backup_delete_backup_vault_lock_configuration]
#' or change the Vault Lock configuration using
#' [`put_backup_vault_lock_configuration`][backup_put_backup_vault_lock_configuration].
#' On and after the lock date, the Vault Lock becomes immutable and cannot
#' be changed or deleted.
#' 
#' If this parameter is not specified, you can delete Vault Lock from the
#' vault using
#' [`delete_backup_vault_lock_configuration`][backup_delete_backup_vault_lock_configuration]
#' or change the Vault Lock configuration using
#' [`put_backup_vault_lock_configuration`][backup_put_backup_vault_lock_configuration]
#' at any time.
#'
#' @keywords internal
#'
#' @rdname backup_put_backup_vault_lock_configuration
backup_put_backup_vault_lock_configuration <- function(BackupVaultName, MinRetentionDays = NULL, MaxRetentionDays = NULL, ChangeableForDays = NULL) {
  op <- new_operation(
    name = "PutBackupVaultLockConfiguration",
    http_method = "PUT",
    http_path = "/backup-vaults/{backupVaultName}/vault-lock",
    paginator = list()
  )
  input <- .backup$put_backup_vault_lock_configuration_input(BackupVaultName = BackupVaultName, MinRetentionDays = MinRetentionDays, MaxRetentionDays = MaxRetentionDays, ChangeableForDays = ChangeableForDays)
  output <- .backup$put_backup_vault_lock_configuration_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$put_backup_vault_lock_configuration <- backup_put_backup_vault_lock_configuration

#' Turns on notifications on a backup vault for the specified topic and
#' events
#'
#' @description
#' Turns on notifications on a backup vault for the specified topic and events.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_put_backup_vault_notifications/](https://www.paws-r-sdk.com/docs/backup_put_backup_vault_notifications/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web Services Region where they are created. They
#' consist of lowercase letters, numbers, and hyphens.
#' @param SNSTopicArn &#91;required&#93; The Amazon Resource Name (ARN) that specifies the topic for a backup
#' vault’s events; for example,
#' `arn:aws:sns:us-west-2:111122223333:MyVaultTopic`.
#' @param BackupVaultEvents &#91;required&#93; An array of events that indicate the status of jobs to back up resources
#' to the backup vault.
#' 
#' For common use cases and code samples, see [Using Amazon SNS to track
#' Backup events](https://docs.aws.amazon.com/aws-backup/latest/devguide/).
#' 
#' The following events are supported:
#' 
#' -   `BACKUP_JOB_STARTED` | `BACKUP_JOB_COMPLETED`
#' 
#' -   `COPY_JOB_STARTED` | `COPY_JOB_SUCCESSFUL` | `COPY_JOB_FAILED`
#' 
#' -   `RESTORE_JOB_STARTED` | `RESTORE_JOB_COMPLETED` |
#'     `RECOVERY_POINT_MODIFIED`
#' 
#' -   `S3_BACKUP_OBJECT_FAILED` | `S3_RESTORE_OBJECT_FAILED`
#' 
#' The list below shows items that are deprecated events (for reference)
#' and are no longer in use. They are no longer supported and will not
#' return statuses or notifications. Refer to the list above for current
#' supported events.
#'
#' @keywords internal
#'
#' @rdname backup_put_backup_vault_notifications
backup_put_backup_vault_notifications <- function(BackupVaultName, SNSTopicArn, BackupVaultEvents) {
  op <- new_operation(
    name = "PutBackupVaultNotifications",
    http_method = "PUT",
    http_path = "/backup-vaults/{backupVaultName}/notification-configuration",
    paginator = list()
  )
  input <- .backup$put_backup_vault_notifications_input(BackupVaultName = BackupVaultName, SNSTopicArn = SNSTopicArn, BackupVaultEvents = BackupVaultEvents)
  output <- .backup$put_backup_vault_notifications_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$put_backup_vault_notifications <- backup_put_backup_vault_notifications

#' This request allows you to send your independent self-run restore test
#' validation results
#'
#' @description
#' This request allows you to send your independent self-run restore test validation results. `RestoreJobId` and `ValidationStatus` are required. Optionally, you can input a `ValidationStatusMessage`.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_put_restore_validation_result/](https://www.paws-r-sdk.com/docs/backup_put_restore_validation_result/) for full documentation.
#'
#' @param RestoreJobId &#91;required&#93; This is a unique identifier of a restore job within Backup.
#' @param ValidationStatus &#91;required&#93; This is the status of your restore validation.
#' @param ValidationStatusMessage This is an optional message string you can input to describe the
#' validation status for the restore test validation.
#'
#' @keywords internal
#'
#' @rdname backup_put_restore_validation_result
backup_put_restore_validation_result <- function(RestoreJobId, ValidationStatus, ValidationStatusMessage = NULL) {
  op <- new_operation(
    name = "PutRestoreValidationResult",
    http_method = "PUT",
    http_path = "/restore-jobs/{restoreJobId}/validations",
    paginator = list()
  )
  input <- .backup$put_restore_validation_result_input(RestoreJobId = RestoreJobId, ValidationStatus = ValidationStatus, ValidationStatusMessage = ValidationStatusMessage)
  output <- .backup$put_restore_validation_result_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$put_restore_validation_result <- backup_put_restore_validation_result

#' Starts an on-demand backup job for the specified resource
#'
#' @description
#' Starts an on-demand backup job for the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_start_backup_job/](https://www.paws-r-sdk.com/docs/backup_start_backup_job/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web Services Region where they are created. They
#' consist of lowercase letters, numbers, and hyphens.
#' @param ResourceArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a resource. The
#' format of the ARN depends on the resource type.
#' @param IamRoleArn &#91;required&#93; Specifies the IAM role ARN used to create the target recovery point; for
#' example, `arn:aws:iam::123456789012:role/S3Access`.
#' @param IdempotencyToken A customer-chosen string that you can use to distinguish between
#' otherwise identical calls to
#' [`start_backup_job`][backup_start_backup_job]. Retrying a successful
#' request with the same idempotency token results in a success message
#' with no action taken.
#' @param StartWindowMinutes A value in minutes after a backup is scheduled before a job will be
#' canceled if it doesn't start successfully. This value is optional, and
#' the default is 8 hours. If this value is included, it must be at least
#' 60 minutes to avoid errors.
#' 
#' This parameter has a maximum value of 100 years (52,560,000 minutes).
#' 
#' During the start window, the backup job status remains in `CREATED`
#' status until it has successfully begun or until the start window time
#' has run out. If within the start window time Backup receives an error
#' that allows the job to be retried, Backup will automatically retry to
#' begin the job at least every 10 minutes until the backup successfully
#' begins (the job status changes to `RUNNING`) or until the job status
#' changes to `EXPIRED` (which is expected to occur when the start window
#' time is over).
#' @param CompleteWindowMinutes A value in minutes during which a successfully started backup must
#' complete, or else Backup will cancel the job. This value is optional.
#' This value begins counting down from when the backup was scheduled. It
#' does not add additional time for `StartWindowMinutes`, or if the backup
#' started later than scheduled.
#' 
#' Like `StartWindowMinutes`, this parameter has a maximum value of 100
#' years (52,560,000 minutes).
#' @param Lifecycle The lifecycle defines when a protected resource is transitioned to cold
#' storage and when it expires. Backup will transition and expire backups
#' automatically according to the lifecycle that you define.
#' 
#' Backups transitioned to cold storage must be stored in cold storage for
#' a minimum of 90 days. Therefore, the “retention” setting must be 90 days
#' greater than the “transition to cold after days” setting. The
#' “transition to cold after days” setting cannot be changed after a backup
#' has been transitioned to cold.
#' 
#' Resource types that are able to be transitioned to cold storage are
#' listed in the "Lifecycle to cold storage" section of the [Feature
#' availability by
#' resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource)
#' table. Backup ignores this expression for other resource types.
#' 
#' This parameter has a maximum value of 100 years (36,500 days).
#' @param RecoveryPointTags To help organize your resources, you can assign your own metadata to the
#' resources that you create. Each tag is a key-value pair.
#' @param BackupOptions Specifies the backup option for a selected resource. This option is only
#' available for Windows Volume Shadow Copy Service (VSS) backup jobs.
#' 
#' Valid values: Set to `"WindowsVSS":"enabled"` to enable the `WindowsVSS`
#' backup option and create a Windows VSS backup. Set to
#' `"WindowsVSS""disabled"` to create a regular backup. The `WindowsVSS`
#' option is not enabled by default.
#'
#' @keywords internal
#'
#' @rdname backup_start_backup_job
backup_start_backup_job <- function(BackupVaultName, ResourceArn, IamRoleArn, IdempotencyToken = NULL, StartWindowMinutes = NULL, CompleteWindowMinutes = NULL, Lifecycle = NULL, RecoveryPointTags = NULL, BackupOptions = NULL) {
  op <- new_operation(
    name = "StartBackupJob",
    http_method = "PUT",
    http_path = "/backup-jobs",
    paginator = list()
  )
  input <- .backup$start_backup_job_input(BackupVaultName = BackupVaultName, ResourceArn = ResourceArn, IamRoleArn = IamRoleArn, IdempotencyToken = IdempotencyToken, StartWindowMinutes = StartWindowMinutes, CompleteWindowMinutes = CompleteWindowMinutes, Lifecycle = Lifecycle, RecoveryPointTags = RecoveryPointTags, BackupOptions = BackupOptions)
  output <- .backup$start_backup_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$start_backup_job <- backup_start_backup_job

#' Starts a job to create a one-time copy of the specified resource
#'
#' @description
#' Starts a job to create a one-time copy of the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_start_copy_job/](https://www.paws-r-sdk.com/docs/backup_start_copy_job/) for full documentation.
#'
#' @param RecoveryPointArn &#91;required&#93; An ARN that uniquely identifies a recovery point to use for the copy
#' job; for example,
#' arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
#' @param SourceBackupVaultName &#91;required&#93; The name of a logical source container where backups are stored. Backup
#' vaults are identified by names that are unique to the account used to
#' create them and the Amazon Web Services Region where they are created.
#' They consist of lowercase letters, numbers, and hyphens.
#' @param DestinationBackupVaultArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a destination
#' backup vault to copy to; for example,
#' `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
#' @param IamRoleArn &#91;required&#93; Specifies the IAM role ARN used to copy the target recovery point; for
#' example, `arn:aws:iam::123456789012:role/S3Access`.
#' @param IdempotencyToken A customer-chosen string that you can use to distinguish between
#' otherwise identical calls to [`start_copy_job`][backup_start_copy_job].
#' Retrying a successful request with the same idempotency token results in
#' a success message with no action taken.
#' @param Lifecycle 
#'
#' @keywords internal
#'
#' @rdname backup_start_copy_job
backup_start_copy_job <- function(RecoveryPointArn, SourceBackupVaultName, DestinationBackupVaultArn, IamRoleArn, IdempotencyToken = NULL, Lifecycle = NULL) {
  op <- new_operation(
    name = "StartCopyJob",
    http_method = "PUT",
    http_path = "/copy-jobs",
    paginator = list()
  )
  input <- .backup$start_copy_job_input(RecoveryPointArn = RecoveryPointArn, SourceBackupVaultName = SourceBackupVaultName, DestinationBackupVaultArn = DestinationBackupVaultArn, IamRoleArn = IamRoleArn, IdempotencyToken = IdempotencyToken, Lifecycle = Lifecycle)
  output <- .backup$start_copy_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$start_copy_job <- backup_start_copy_job

#' Starts an on-demand report job for the specified report plan
#'
#' @description
#' Starts an on-demand report job for the specified report plan.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_start_report_job/](https://www.paws-r-sdk.com/docs/backup_start_report_job/) for full documentation.
#'
#' @param ReportPlanName &#91;required&#93; The unique name of a report plan.
#' @param IdempotencyToken A customer-chosen string that you can use to distinguish between
#' otherwise identical calls to `StartReportJobInput`. Retrying a
#' successful request with the same idempotency token results in a success
#' message with no action taken.
#'
#' @keywords internal
#'
#' @rdname backup_start_report_job
backup_start_report_job <- function(ReportPlanName, IdempotencyToken = NULL) {
  op <- new_operation(
    name = "StartReportJob",
    http_method = "POST",
    http_path = "/audit/report-jobs/{reportPlanName}",
    paginator = list()
  )
  input <- .backup$start_report_job_input(ReportPlanName = ReportPlanName, IdempotencyToken = IdempotencyToken)
  output <- .backup$start_report_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$start_report_job <- backup_start_report_job

#' Recovers the saved resource identified by an Amazon Resource Name (ARN)
#'
#' @description
#' Recovers the saved resource identified by an Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/backup_start_restore_job/](https://www.paws-r-sdk.com/docs/backup_start_restore_job/) for full documentation.
#'
#' @param RecoveryPointArn &#91;required&#93; An ARN that uniquely identifies a recovery point; for example,
#' `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
#' @param Metadata &#91;required&#93; A set of metadata key-value pairs. Contains information, such as a
#' resource name, required to restore a recovery point.
#' 
#' You can get configuration metadata about a resource at the time it was
#' backed up by calling
#' [`get_recovery_point_restore_metadata`][backup_get_recovery_point_restore_metadata].
#' However, values in addition to those provided by
#' [`get_recovery_point_restore_metadata`][backup_get_recovery_point_restore_metadata]
#' might be required to restore a resource. For example, you might need to
#' provide a new resource name if the original already exists.
#' 
#' You need to specify specific metadata to restore an Amazon Elastic File
#' System (Amazon EFS) instance:
#' 
#' -   `file-system-id`: The ID of the Amazon EFS file system that is
#'     backed up by Backup. Returned in
#'     [`get_recovery_point_restore_metadata`][backup_get_recovery_point_restore_metadata].
#' 
#' -   `Encrypted`: A Boolean value that, if true, specifies that the file
#'     system is encrypted. If `KmsKeyId` is specified, `Encrypted` must be
#'     set to `true`.
#' 
#' -   `KmsKeyId`: Specifies the Amazon Web Services KMS key that is used
#'     to encrypt the restored file system. You can specify a key from
#'     another Amazon Web Services account provided that key it is properly
#'     shared with your account via Amazon Web Services KMS.
#' 
#' -   `PerformanceMode`: Specifies the throughput mode of the file system.
#' 
#' -   `CreationToken`: A user-supplied value that ensures the uniqueness
#'     (idempotency) of the request.
#' 
#' -   `newFileSystem`: A Boolean value that, if true, specifies that the
#'     recovery point is restored to a new Amazon EFS file system.
#' 
#' -   `ItemsToRestore`: An array of one to five strings where each string
#'     is a file path. Use `ItemsToRestore` to restore specific files or
#'     directories rather than the entire file system. This parameter is
#'     optional. For example, `"itemsToRestore":"[\"/my.test\"]"`.
#' @param IamRoleArn The Amazon Resource Name (ARN) of the IAM role that Backup uses to
#' create the target resource; for example:
#' `arn:aws:iam::123456789012:role/S3Access`.
#' @param IdempotencyToken A customer-chosen string that you can use to distinguish between
#' otherwise identical calls to
#' [`start_restore_job`][backup_start_restore_job]. Retrying a successful
#' request with the same idempotency token results in a success message
#' with no action taken.
#' @param ResourceType Starts a job to restore a recovery point for one of the following
#' resources:
#' 
#' -   `Aurora` for Amazon Aurora
#' 
#' -   `DocumentDB` for Amazon DocumentDB (with MongoDB compatibility)
#' 
#' -   `CloudFormation` for CloudFormation
#' 
#' -   `DynamoDB` for Amazon DynamoDB
#' 
#' -   `EBS` for Amazon Elastic Block Store
#' 
#' -   `EC2` for Amazon Elastic Compute Cloud
#' 
#' -   `EFS` for Amazon Elastic File System
#' 
#' -   `FSx` for Amazon FSx
#' 
#' -   `Neptune` for Amazon Neptune
#' 
#' -   `RDS` for Amazon Relational Database Service
#' 
#' -   `Redshift` for Amazon Redshift
#' 
#' -   `Storage Gateway` for Storage Gateway
#' 
#' -   `S3` for Amazon S3
#' 
#' -   `Timestream` for Amazon Timestream
#' 
#' -   `VirtualMachine` for virtual machines
#' @param CopySourceTagsToRestoredResource This is an optional parameter. If this equals `True`, tags included in
#' the backup will be copied to the restored resource.
#' 
#' This can only be applied to backups created through Backup.
#'
#' @keywords internal
#'
#' @rdname backup_start_restore_job
backup_start_restore_job <- function(RecoveryPointArn, Metadata, IamRoleArn = NULL, IdempotencyToken = NULL, ResourceType = NULL, CopySourceTagsToRestoredResource = NULL) {
  op <- new_operation(
    name = "StartRestoreJob",
    http_method = "PUT",
    http_path = "/restore-jobs",
    paginator = list()
  )
  input <- .backup$start_restore_job_input(RecoveryPointArn = RecoveryPointArn, Metadata = Metadata, IamRoleArn = IamRoleArn, IdempotencyToken = IdempotencyToken, ResourceType = ResourceType, CopySourceTagsToRestoredResource = CopySourceTagsToRestoredResource)
  output <- .backup$start_restore_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$start_restore_job <- backup_start_restore_job

#' Attempts to cancel a job to create a one-time backup of a resource
#'
#' @description
#' Attempts to cancel a job to create a one-time backup of a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_stop_backup_job/](https://www.paws-r-sdk.com/docs/backup_stop_backup_job/) for full documentation.
#'
#' @param BackupJobId &#91;required&#93; Uniquely identifies a request to Backup to back up a resource.
#'
#' @keywords internal
#'
#' @rdname backup_stop_backup_job
backup_stop_backup_job <- function(BackupJobId) {
  op <- new_operation(
    name = "StopBackupJob",
    http_method = "POST",
    http_path = "/backup-jobs/{backupJobId}",
    paginator = list()
  )
  input <- .backup$stop_backup_job_input(BackupJobId = BackupJobId)
  output <- .backup$stop_backup_job_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$stop_backup_job <- backup_stop_backup_job

#' Assigns a set of key-value pairs to a recovery point, backup plan, or
#' backup vault identified by an Amazon Resource Name (ARN)
#'
#' @description
#' Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/backup_tag_resource/](https://www.paws-r-sdk.com/docs/backup_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; An ARN that uniquely identifies a resource. The format of the ARN
#' depends on the type of the tagged resource.
#' @param Tags &#91;required&#93; Key-value pairs that are used to help organize your resources. You can
#' assign your own metadata to the resources you create. For clarity, this
#' is the structure to assign tags: `[{"Key":"string","Value":"string"}]`.
#'
#' @keywords internal
#'
#' @rdname backup_tag_resource
backup_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .backup$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .backup$tag_resource_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$tag_resource <- backup_tag_resource

#' Removes a set of key-value pairs from a recovery point, backup plan, or
#' backup vault identified by an Amazon Resource Name (ARN)
#'
#' @description
#' Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN)
#'
#' See [https://www.paws-r-sdk.com/docs/backup_untag_resource/](https://www.paws-r-sdk.com/docs/backup_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; An ARN that uniquely identifies a resource. The format of the ARN
#' depends on the type of the tagged resource.
#' @param TagKeyList &#91;required&#93; A list of keys to identify which key-value tags to remove from a
#' resource.
#'
#' @keywords internal
#'
#' @rdname backup_untag_resource
backup_untag_resource <- function(ResourceArn, TagKeyList) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/untag/{resourceArn}",
    paginator = list()
  )
  input <- .backup$untag_resource_input(ResourceArn = ResourceArn, TagKeyList = TagKeyList)
  output <- .backup$untag_resource_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$untag_resource <- backup_untag_resource

#' Updates an existing backup plan identified by its backupPlanId with the
#' input document in JSON format
#'
#' @description
#' Updates an existing backup plan identified by its `backupPlanId` with the input document in JSON format. The new version is uniquely identified by a `VersionId`.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_update_backup_plan/](https://www.paws-r-sdk.com/docs/backup_update_backup_plan/) for full documentation.
#'
#' @param BackupPlanId &#91;required&#93; Uniquely identifies a backup plan.
#' @param BackupPlan &#91;required&#93; Specifies the body of a backup plan. Includes a `BackupPlanName` and one
#' or more sets of `Rules`.
#'
#' @keywords internal
#'
#' @rdname backup_update_backup_plan
backup_update_backup_plan <- function(BackupPlanId, BackupPlan) {
  op <- new_operation(
    name = "UpdateBackupPlan",
    http_method = "POST",
    http_path = "/backup/plans/{backupPlanId}",
    paginator = list()
  )
  input <- .backup$update_backup_plan_input(BackupPlanId = BackupPlanId, BackupPlan = BackupPlan)
  output <- .backup$update_backup_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$update_backup_plan <- backup_update_backup_plan

#' Updates an existing framework identified by its FrameworkName with the
#' input document in JSON format
#'
#' @description
#' Updates an existing framework identified by its `FrameworkName` with the input document in JSON format.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_update_framework/](https://www.paws-r-sdk.com/docs/backup_update_framework/) for full documentation.
#'
#' @param FrameworkName &#91;required&#93; The unique name of a framework. This name is between 1 and 256
#' characters, starting with a letter, and consisting of letters (a-z,
#' A-Z), numbers (0-9), and underscores (_).
#' @param FrameworkDescription An optional description of the framework with a maximum 1,024
#' characters.
#' @param FrameworkControls A list of the controls that make up the framework. Each control in the
#' list has a name, input parameters, and scope.
#' @param IdempotencyToken A customer-chosen string that you can use to distinguish between
#' otherwise identical calls to `UpdateFrameworkInput`. Retrying a
#' successful request with the same idempotency token results in a success
#' message with no action taken.
#'
#' @keywords internal
#'
#' @rdname backup_update_framework
backup_update_framework <- function(FrameworkName, FrameworkDescription = NULL, FrameworkControls = NULL, IdempotencyToken = NULL) {
  op <- new_operation(
    name = "UpdateFramework",
    http_method = "PUT",
    http_path = "/audit/frameworks/{frameworkName}",
    paginator = list()
  )
  input <- .backup$update_framework_input(FrameworkName = FrameworkName, FrameworkDescription = FrameworkDescription, FrameworkControls = FrameworkControls, IdempotencyToken = IdempotencyToken)
  output <- .backup$update_framework_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$update_framework <- backup_update_framework

#' Updates whether the Amazon Web Services account is opted in to
#' cross-account backup
#'
#' @description
#' Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not an Organizations management account. Use the [`describe_global_settings`][backup_describe_global_settings] API to determine the current settings.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_update_global_settings/](https://www.paws-r-sdk.com/docs/backup_update_global_settings/) for full documentation.
#'
#' @param GlobalSettings A value for `isCrossAccountBackupEnabled` and a Region. Example:
#' `update-global-settings --global-settings isCrossAccountBackupEnabled=false --region us-west-2`.
#'
#' @keywords internal
#'
#' @rdname backup_update_global_settings
backup_update_global_settings <- function(GlobalSettings = NULL) {
  op <- new_operation(
    name = "UpdateGlobalSettings",
    http_method = "PUT",
    http_path = "/global-settings",
    paginator = list()
  )
  input <- .backup$update_global_settings_input(GlobalSettings = GlobalSettings)
  output <- .backup$update_global_settings_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$update_global_settings <- backup_update_global_settings

#' Sets the transition lifecycle of a recovery point
#'
#' @description
#' Sets the transition lifecycle of a recovery point.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_update_recovery_point_lifecycle/](https://www.paws-r-sdk.com/docs/backup_update_recovery_point_lifecycle/) for full documentation.
#'
#' @param BackupVaultName &#91;required&#93; The name of a logical container where backups are stored. Backup vaults
#' are identified by names that are unique to the account used to create
#' them and the Amazon Web Services Region where they are created. They
#' consist of lowercase letters, numbers, and hyphens.
#' @param RecoveryPointArn &#91;required&#93; An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
#' for example,
#' `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
#' @param Lifecycle The lifecycle defines when a protected resource is transitioned to cold
#' storage and when it expires. Backup transitions and expires backups
#' automatically according to the lifecycle that you define.
#' 
#' Backups transitioned to cold storage must be stored in cold storage for
#' a minimum of 90 days. Therefore, the “retention” setting must be 90 days
#' greater than the “transition to cold after days” setting. The
#' “transition to cold after days” setting cannot be changed after a backup
#' has been transitioned to cold.
#'
#' @keywords internal
#'
#' @rdname backup_update_recovery_point_lifecycle
backup_update_recovery_point_lifecycle <- function(BackupVaultName, RecoveryPointArn, Lifecycle = NULL) {
  op <- new_operation(
    name = "UpdateRecoveryPointLifecycle",
    http_method = "POST",
    http_path = "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}",
    paginator = list()
  )
  input <- .backup$update_recovery_point_lifecycle_input(BackupVaultName = BackupVaultName, RecoveryPointArn = RecoveryPointArn, Lifecycle = Lifecycle)
  output <- .backup$update_recovery_point_lifecycle_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$update_recovery_point_lifecycle <- backup_update_recovery_point_lifecycle

#' Updates the current service opt-in settings for the Region
#'
#' @description
#' Updates the current service opt-in settings for the Region.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_update_region_settings/](https://www.paws-r-sdk.com/docs/backup_update_region_settings/) for full documentation.
#'
#' @param ResourceTypeOptInPreference Updates the list of services along with the opt-in preferences for the
#' Region.
#' 
#' If resource assignments are only based on tags, then service opt-in
#' settings are applied. If a resource type is explicitly assigned to a
#' backup plan, such as Amazon S3, Amazon EC2, or Amazon RDS, it will be
#' included in the backup even if the opt-in is not enabled for that
#' particular service. If both a resource type and tags are specified in a
#' resource assignment, the resource type specified in the backup plan
#' takes priority over the tag condition. Service opt-in settings are
#' disregarded in this situation.
#' @param ResourceTypeManagementPreference Enables or disables full Backup management of backups for a resource
#' type. To enable full Backup management for DynamoDB along with [Backup's
#' advanced DynamoDB backup
#' features](https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html),
#' follow the procedure to [enable advanced DynamoDB backup
#' programmatically](https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html#advanced-ddb-backup-enable-cli).
#'
#' @keywords internal
#'
#' @rdname backup_update_region_settings
backup_update_region_settings <- function(ResourceTypeOptInPreference = NULL, ResourceTypeManagementPreference = NULL) {
  op <- new_operation(
    name = "UpdateRegionSettings",
    http_method = "PUT",
    http_path = "/account-settings",
    paginator = list()
  )
  input <- .backup$update_region_settings_input(ResourceTypeOptInPreference = ResourceTypeOptInPreference, ResourceTypeManagementPreference = ResourceTypeManagementPreference)
  output <- .backup$update_region_settings_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$update_region_settings <- backup_update_region_settings

#' Updates an existing report plan identified by its ReportPlanName with
#' the input document in JSON format
#'
#' @description
#' Updates an existing report plan identified by its `ReportPlanName` with the input document in JSON format.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_update_report_plan/](https://www.paws-r-sdk.com/docs/backup_update_report_plan/) for full documentation.
#'
#' @param ReportPlanName &#91;required&#93; The unique name of the report plan. This name is between 1 and 256
#' characters, starting with a letter, and consisting of letters (a-z,
#' A-Z), numbers (0-9), and underscores (_).
#' @param ReportPlanDescription An optional description of the report plan with a maximum 1,024
#' characters.
#' @param ReportDeliveryChannel A structure that contains information about where to deliver your
#' reports, specifically your Amazon S3 bucket name, S3 key prefix, and the
#' formats of your reports.
#' @param ReportSetting Identifies the report template for the report. Reports are built using a
#' report template. The report templates are:
#' 
#' `RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT`
#' 
#' If the report template is `RESOURCE_COMPLIANCE_REPORT` or
#' `CONTROL_COMPLIANCE_REPORT`, this API resource also describes the report
#' coverage by Amazon Web Services Regions and frameworks.
#' @param IdempotencyToken A customer-chosen string that you can use to distinguish between
#' otherwise identical calls to `UpdateReportPlanInput`. Retrying a
#' successful request with the same idempotency token results in a success
#' message with no action taken.
#'
#' @keywords internal
#'
#' @rdname backup_update_report_plan
backup_update_report_plan <- function(ReportPlanName, ReportPlanDescription = NULL, ReportDeliveryChannel = NULL, ReportSetting = NULL, IdempotencyToken = NULL) {
  op <- new_operation(
    name = "UpdateReportPlan",
    http_method = "PUT",
    http_path = "/audit/report-plans/{reportPlanName}",
    paginator = list()
  )
  input <- .backup$update_report_plan_input(ReportPlanName = ReportPlanName, ReportPlanDescription = ReportPlanDescription, ReportDeliveryChannel = ReportDeliveryChannel, ReportSetting = ReportSetting, IdempotencyToken = IdempotencyToken)
  output <- .backup$update_report_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$update_report_plan <- backup_update_report_plan

#' This request will send changes to your specified restore testing plan
#'
#' @description
#' This request will send changes to your specified restore testing plan. `RestoreTestingPlanName` cannot be updated after it is created.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_update_restore_testing_plan/](https://www.paws-r-sdk.com/docs/backup_update_restore_testing_plan/) for full documentation.
#'
#' @param RestoreTestingPlan &#91;required&#93; Specifies the body of a restore testing plan.
#' @param RestoreTestingPlanName &#91;required&#93; This is the restore testing plan name you wish to update.
#'
#' @keywords internal
#'
#' @rdname backup_update_restore_testing_plan
backup_update_restore_testing_plan <- function(RestoreTestingPlan, RestoreTestingPlanName) {
  op <- new_operation(
    name = "UpdateRestoreTestingPlan",
    http_method = "PUT",
    http_path = "/restore-testing/plans/{RestoreTestingPlanName}",
    paginator = list()
  )
  input <- .backup$update_restore_testing_plan_input(RestoreTestingPlan = RestoreTestingPlan, RestoreTestingPlanName = RestoreTestingPlanName)
  output <- .backup$update_restore_testing_plan_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$update_restore_testing_plan <- backup_update_restore_testing_plan

#' Most elements except the RestoreTestingSelectionName can be updated with
#' this request
#'
#' @description
#' Most elements except the `RestoreTestingSelectionName` can be updated with this request.
#'
#' See [https://www.paws-r-sdk.com/docs/backup_update_restore_testing_selection/](https://www.paws-r-sdk.com/docs/backup_update_restore_testing_selection/) for full documentation.
#'
#' @param RestoreTestingPlanName &#91;required&#93; The restore testing plan name is required to update the indicated
#' testing plan.
#' @param RestoreTestingSelection &#91;required&#93; To update your restore testing selection, you can use either protected
#' resource ARNs or conditions, but not both. That is, if your selection
#' has `ProtectedResourceArns`, requesting an update with the parameter
#' `ProtectedResourceConditions` will be unsuccessful.
#' @param RestoreTestingSelectionName &#91;required&#93; This is the required restore testing selection name of the restore
#' testing selection you wish to update.
#'
#' @keywords internal
#'
#' @rdname backup_update_restore_testing_selection
backup_update_restore_testing_selection <- function(RestoreTestingPlanName, RestoreTestingSelection, RestoreTestingSelectionName) {
  op <- new_operation(
    name = "UpdateRestoreTestingSelection",
    http_method = "PUT",
    http_path = "/restore-testing/plans/{RestoreTestingPlanName}/selections/{RestoreTestingSelectionName}",
    paginator = list()
  )
  input <- .backup$update_restore_testing_selection_input(RestoreTestingPlanName = RestoreTestingPlanName, RestoreTestingSelection = RestoreTestingSelection, RestoreTestingSelectionName = RestoreTestingSelectionName)
  output <- .backup$update_restore_testing_selection_output()
  config <- get_config()
  svc <- .backup$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.backup$operations$update_restore_testing_selection <- backup_update_restore_testing_selection
