% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_abort_vault_lock}
\alias{glacier_abort_vault_lock}
\title{This operation aborts the vault locking process if the vault lock is not
in the Locked state}
\usage{
glacier_abort_vault_lock(accountId, vaultName)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID. This value must match the
AWS account ID associated with the credentials used to sign the request.
You can either specify an AWS account ID or optionally a single '\code{-}'
(hyphen), in which case Amazon Glacier uses the AWS account ID
associated with the credentials used to sign the request. If you specify
your account ID, do not include any hyphens ('-') in the ID.}

\item{vaultName}{[required] The name of the vault.}
}
\description{
This operation aborts the vault locking process if the vault lock is not in the \code{Locked} state. If the vault lock is in the \code{Locked} state when this operation is requested, the operation returns an \code{AccessDeniedException} error. Aborting the vault locking process removes the vault lock policy from the specified vault.

See \url{https://www.paws-r-sdk.com/docs/glacier_abort_vault_lock/} for full documentation.
}
\keyword{internal}
