% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspacedata_operations.R
\name{finspacedata_update_permission_group}
\alias{finspacedata_update_permission_group}
\title{Modifies the details of a permission group}
\usage{
finspacedata_update_permission_group(
  permissionGroupId,
  name = NULL,
  description = NULL,
  applicationPermissions = NULL,
  clientToken = NULL
)
}
\arguments{
\item{permissionGroupId}{[required] The unique identifier for the permission group to update.}

\item{name}{The name of the permission group.}

\item{description}{A brief description for the permission group.}

\item{applicationPermissions}{The permissions that are granted to a specific group for accessing the
FinSpace application.

When assigning application permissions, be aware that the permission
\code{ManageUsersAndGroups} allows users to grant themselves or others access
to any functionality in their FinSpace environment's application. It
should only be granted to trusted users.
\itemize{
\item \code{\link[=finspacedata_create_dataset]{create_dataset}} – Group members can
create new datasets.
\item \code{ManageClusters} – Group members can manage Apache Spark clusters
from FinSpace notebooks.
\item \code{ManageUsersAndGroups} – Group members can manage users and
permission groups. This is a privileged permission that allows users
to grant themselves or others access to any functionality in the
application. It should only be granted to trusted users.
\item \code{ManageAttributeSets} – Group members can manage attribute sets.
\item \code{ViewAuditData} – Group members can view audit data.
\item \code{AccessNotebooks} – Group members will have access to FinSpace
notebooks.
\item \code{GetTemporaryCredentials} – Group members can get temporary API
credentials.
}}

\item{clientToken}{A token that ensures idempotency. This token expires in 10 minutes.}
}
\description{
Modifies the details of a permission group. You cannot modify a \code{permissionGroupID}.

See \url{https://www.paws-r-sdk.com/docs/finspacedata_update_permission_group/} for full documentation.
}
\keyword{internal}
