% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_update_framework}
\alias{backup_update_framework}
\title{Updates an existing framework identified by its FrameworkName with the
input document in JSON format}
\usage{
backup_update_framework(
  FrameworkName,
  FrameworkDescription = NULL,
  FrameworkControls = NULL,
  IdempotencyToken = NULL
)
}
\arguments{
\item{FrameworkName}{[required] The unique name of a framework. This name is between 1 and 256
characters, starting with a letter, and consisting of letters (a-z,
A-Z), numbers (0-9), and underscores (_).}

\item{FrameworkDescription}{An optional description of the framework with a maximum 1,024
characters.}

\item{FrameworkControls}{A list of the controls that make up the framework. Each control in the
list has a name, input parameters, and scope.}

\item{IdempotencyToken}{A customer-chosen string that you can use to distinguish between
otherwise identical calls to \code{UpdateFrameworkInput}. Retrying a
successful request with the same idempotency token results in a success
message with no action taken.}
}
\description{
Updates an existing framework identified by its \code{FrameworkName} with the input document in JSON format.

See \url{https://www.paws-r-sdk.com/docs/backup_update_framework/} for full documentation.
}
\keyword{internal}
