% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efs_operations.R
\name{efs_update_file_system}
\alias{efs_update_file_system}
\title{Updates the throughput mode or the amount of provisioned throughput of
an existing file system}
\usage{
efs_update_file_system(
  FileSystemId,
  ThroughputMode = NULL,
  ProvisionedThroughputInMibps = NULL
)
}
\arguments{
\item{FileSystemId}{[required] The ID of the file system that you want to update.}

\item{ThroughputMode}{(Optional) Updates the file system's throughput mode. If you're not
updating your throughput mode, you don't need to provide this value in
your request. If you are changing the \code{ThroughputMode} to \code{provisioned},
you must also set a value for \code{ProvisionedThroughputInMibps}.}

\item{ProvisionedThroughputInMibps}{(Optional) Sets the amount of provisioned throughput, in MiB/s, for the
file system. Valid values are 1-1024. If you are changing the throughput
mode to provisioned, you must also provide the amount of provisioned
throughput. Required if \code{ThroughputMode} is changed to \code{provisioned} on
update.}
}
\description{
Updates the throughput mode or the amount of provisioned throughput of an existing file system.

See \url{https://www.paws-r-sdk.com/docs/efs_update_file_system/} for full documentation.
}
\keyword{internal}
