% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_list_restore_jobs}
\alias{backup_list_restore_jobs}
\title{Returns a list of jobs that Backup initiated to restore a saved
resource, including details about the recovery process}
\usage{
backup_list_restore_jobs(
  NextToken = NULL,
  MaxResults = NULL,
  ByAccountId = NULL,
  ByCreatedBefore = NULL,
  ByCreatedAfter = NULL,
  ByStatus = NULL,
  ByCompleteBefore = NULL,
  ByCompleteAfter = NULL
)
}
\arguments{
\item{NextToken}{The next item following a partial list of returned items. For example,
if a request is made to return \code{maxResults} number of items, \code{NextToken}
allows you to return more items in your list starting at the location
pointed to by the next token.}

\item{MaxResults}{The maximum number of items to be returned.}

\item{ByAccountId}{The account ID to list the jobs from. Returns only restore jobs
associated with the specified account ID.}

\item{ByCreatedBefore}{Returns only restore jobs that were created before the specified date.}

\item{ByCreatedAfter}{Returns only restore jobs that were created after the specified date.}

\item{ByStatus}{Returns only restore jobs associated with the specified job status.}

\item{ByCompleteBefore}{Returns only copy jobs completed before a date expressed in Unix format
and Coordinated Universal Time (UTC).}

\item{ByCompleteAfter}{Returns only copy jobs completed after a date expressed in Unix format
and Coordinated Universal Time (UTC).}
}
\description{
Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery process.

See \url{https://www.paws-r-sdk.com/docs/backup_list_restore_jobs/} for full documentation.
}
\keyword{internal}
