% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_update_smb_file_share}
\alias{storagegateway_update_smb_file_share}
\title{Updates a Server Message Block (SMB) file share}
\usage{
storagegateway_update_smb_file_share(
  FileShareARN,
  KMSEncrypted = NULL,
  KMSKey = NULL,
  DefaultStorageClass = NULL,
  ObjectACL = NULL,
  ReadOnly = NULL,
  GuessMIMETypeEnabled = NULL,
  RequesterPays = NULL,
  SMBACLEnabled = NULL,
  AccessBasedEnumeration = NULL,
  AdminUserList = NULL,
  ValidUserList = NULL,
  InvalidUserList = NULL,
  AuditDestinationARN = NULL,
  CaseSensitivity = NULL,
  FileShareName = NULL,
  CacheAttributes = NULL,
  NotificationPolicy = NULL,
  OplocksEnabled = NULL
)
}
\arguments{
\item{FileShareARN}{[required] The Amazon Resource Name (ARN) of the SMB file share that you want to
update.}

\item{KMSEncrypted}{Set to \code{true} to use Amazon S3 server-side encryption with your own KMS
key, or \code{false} to use a key managed by Amazon S3. Optional.

Valid Values: \code{true} | \code{false}}

\item{KMSKey}{The Amazon Resource Name (ARN) of a symmetric customer master key (CMK)
used for Amazon S3 server-side encryption. Storage Gateway does not
support asymmetric CMKs. This value can only be set when \code{KMSEncrypted}
is \code{true}. Optional.}

\item{DefaultStorageClass}{The default storage class for objects put into an Amazon S3 bucket by
the S3 File Gateway. The default value is \code{S3_STANDARD}. Optional.

Valid Values: \code{S3_STANDARD} | \code{S3_INTELLIGENT_TIERING} |
\code{S3_STANDARD_IA} | \code{S3_ONEZONE_IA}}

\item{ObjectACL}{A value that sets the access control list (ACL) permission for objects
in the S3 bucket that a S3 File Gateway puts objects into. The default
value is \code{private}.}

\item{ReadOnly}{A value that sets the write status of a file share. Set this value to
\code{true} to set write status to read-only, otherwise set to \code{false}.

Valid Values: \code{true} | \code{false}}

\item{GuessMIMETypeEnabled}{A value that enables guessing of the MIME type for uploaded objects
based on file extensions. Set this value to \code{true} to enable MIME type
guessing, otherwise set to \code{false}. The default value is \code{true}.

Valid Values: \code{true} | \code{false}}

\item{RequesterPays}{A value that sets who pays the cost of the request and the cost
associated with data download from the S3 bucket. If this value is set
to \code{true}, the requester pays the costs; otherwise, the S3 bucket owner
pays. However, the S3 bucket owner always pays the cost of storing data.

\code{RequesterPays} is a configuration for the S3 bucket that backs the file
share, so make sure that the configuration on the file share is the same
as the S3 bucket configuration.

Valid Values: \code{true} | \code{false}}

\item{SMBACLEnabled}{Set this value to \code{true} to enable access control list (ACL) on the SMB
file share. Set it to \code{false} to map file and directory permissions to
the POSIX permissions.

For more information, see \href{https://docs.aws.amazon.com/storagegateway/index.html}{Using Microsoft Windows ACLs to control access to an SMB file share} in the
\emph{Storage Gateway User Guide}.

Valid Values: \code{true} | \code{false}}

\item{AccessBasedEnumeration}{The files and folders on this share will only be visible to users with
read access.}

\item{AdminUserList}{A list of users or groups in the Active Directory that have
administrator rights to the file share. A group must be prefixed with
the @ character. Acceptable formats include: \verb{DOMAIN\\\\User1}, \code{user1},
\verb{@group1}, and \verb{@DOMAIN\\\\group1}. Can only be set if Authentication is
set to \code{ActiveDirectory}.}

\item{ValidUserList}{A list of users or groups in the Active Directory that are allowed to
access the file share. A group must be prefixed with the @ character.
Acceptable formats include: \verb{DOMAIN\\\\User1}, \code{user1}, \verb{@group1}, and
\verb{@DOMAIN\\\\group1}. Can only be set if Authentication is set to
\code{ActiveDirectory}.}

\item{InvalidUserList}{A list of users or groups in the Active Directory that are not allowed
to access the file share. A group must be prefixed with the @ character.
Acceptable formats include: \verb{DOMAIN\\\\User1}, \code{user1}, \verb{@group1}, and
\verb{@DOMAIN\\\\group1}. Can only be set if Authentication is set to
\code{ActiveDirectory}.}

\item{AuditDestinationARN}{The Amazon Resource Name (ARN) of the storage used for audit logs.}

\item{CaseSensitivity}{The case of an object name in an Amazon S3 bucket. For
\code{ClientSpecified}, the client determines the case sensitivity. For
\code{CaseSensitive}, the gateway determines the case sensitivity. The
default value is \code{ClientSpecified}.}

\item{FileShareName}{The name of the file share. Optional.

\code{FileShareName} must be set if an S3 prefix name is set in
\code{LocationARN}, or if an access point or access point alias is used.}

\item{CacheAttributes}{Specifies refresh cache information for the file share.}

\item{NotificationPolicy}{The notification policy of the file share. \code{SettlingTimeInSeconds}
controls the number of seconds to wait after the last point in time a
client wrote to a file before generating an \code{ObjectUploaded}
notification. Because clients can make many small writes to files, it's
best to set this parameter for as long as possible to avoid generating
multiple notifications for the same file in a small time period.

\code{SettlingTimeInSeconds} has no effect on the timing of the object
uploading to Amazon S3, only the timing of the notification.

The following example sets \code{NotificationPolicy} on with
\code{SettlingTimeInSeconds} set to 60.

\verb{\{\\"Upload\\": \{\\"SettlingTimeInSeconds\\": 60\}\}}

The following example sets \code{NotificationPolicy} off.

\code{{}}}

\item{OplocksEnabled}{Specifies whether opportunistic locking is enabled for the SMB file
share.

Enabling opportunistic locking on case-sensitive shares is not
recommended for workloads that involve access to files with the same
name in different case.

Valid Values: \code{true} | \code{false}}
}
\description{
Updates a Server Message Block (SMB) file share. This operation is only supported for S3 File Gateways.

See \url{https://paws-r.github.io/docs/storagegateway/update_smb_file_share.html} for full documentation.
}
\keyword{internal}
