% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebs_operations.R
\name{ebs_start_snapshot}
\alias{ebs_start_snapshot}
\title{Creates a new Amazon EBS snapshot}
\usage{
ebs_start_snapshot(
  VolumeSize,
  ParentSnapshotId = NULL,
  Tags = NULL,
  Description = NULL,
  ClientToken = NULL,
  Encrypted = NULL,
  KmsKeyArn = NULL,
  Timeout = NULL
)
}
\arguments{
\item{VolumeSize}{[required] The size of the volume, in GiB. The maximum size is \code{65536} GiB (64
TiB).}

\item{ParentSnapshotId}{The ID of the parent snapshot. If there is no parent snapshot, or if you
are creating the first snapshot for an on-premises volume, omit this
parameter.

You can't specify \strong{ParentSnapshotId} and \strong{Encrypted} in the same
request. If you specify both parameters, the request fails with
\code{ValidationException}.

The encryption status of the snapshot depends on the values that you
specify for \strong{Encrypted}, \strong{KmsKeyArn}, and \strong{ParentSnapshotId}, and
whether your Amazon Web Services account is enabled for \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default}{encryption by default}.
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebsapis-using-encryption.html}{Using encryption}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

If you specify an encrypted parent snapshot, you must have permission to
use the KMS key that was used to encrypt the parent snapshot. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebsapi-permissions.html#ebsapi-kms-permissions}{Permissions to use Key Management Service keys}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{Tags}{The tags to apply to the snapshot.}

\item{Description}{A description for the snapshot.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Idempotency ensures that an API request
completes only once. With an idempotent request, if the original request
completes successfully. The subsequent retries with the same client
token return the result from the original successful request and they
have no additional effect.

If you do not specify a client token, one is automatically generated by
the Amazon Web Services SDK.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html}{Idempotency for StartSnapshot API}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{Encrypted}{Indicates whether to encrypt the snapshot.

You can't specify \strong{Encrypted} and \strong{ParentSnapshotId} in the same
request. If you specify both parameters, the request fails with
\code{ValidationException}.

The encryption status of the snapshot depends on the values that you
specify for \strong{Encrypted}, \strong{KmsKeyArn}, and \strong{ParentSnapshotId}, and
whether your Amazon Web Services account is enabled for \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default}{encryption by default}.
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebsapis-using-encryption.html}{Using encryption}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

To create an encrypted snapshot, you must have permission to use the KMS
key. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebsapi-permissions.html#ebsapi-kms-permissions}{Permissions to use Key Management Service keys}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{KmsKeyArn}{The Amazon Resource Name (ARN) of the Key Management Service (KMS) key
to be used to encrypt the snapshot.

The encryption status of the snapshot depends on the values that you
specify for \strong{Encrypted}, \strong{KmsKeyArn}, and \strong{ParentSnapshotId}, and
whether your Amazon Web Services account is enabled for \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default}{encryption by default}.
For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebsapis-using-encryption.html}{Using encryption}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

To create an encrypted snapshot, you must have permission to use the KMS
key. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebsapi-permissions.html#ebsapi-kms-permissions}{Permissions to use Key Management Service keys}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{Timeout}{The amount of time (in minutes) after which the snapshot is
automatically cancelled if:
\itemize{
\item No blocks are written to the snapshot.
\item The snapshot is not completed after writing the last block of data.
}

If no value is specified, the timeout defaults to \code{60} minutes.}
}
\description{
Creates a new Amazon EBS snapshot. The new snapshot enters the \code{pending} state after the request completes.

See \url{https://paws-r.github.io/docs/ebs/start_snapshot.html} for full documentation.
}
\keyword{internal}
