# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS S3 Control
#'
#' @description
#' AWS S3 Control provides access to Amazon S3 control plane operations.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- s3control(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- s3control()
#' svc$create_access_point(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=s3control_create_access_point]{create_access_point} \tab Creates an access point and associates it with the specified bucket \cr
#'  \link[=s3control_create_job]{create_job} \tab You can use Amazon S3 Batch Operations to perform large-scale Batch Operations on Amazon S3 objects \cr
#'  \link[=s3control_delete_access_point]{delete_access_point} \tab Deletes the specified access point \cr
#'  \link[=s3control_delete_access_point_policy]{delete_access_point_policy} \tab Deletes the access point policy for the specified access point \cr
#'  \link[=s3control_delete_job_tagging]{delete_job_tagging} \tab Removes the entire tag set from the specified Amazon S3 Batch Operations job \cr
#'  \link[=s3control_delete_public_access_block]{delete_public_access_block} \tab Removes the PublicAccessBlock configuration for an Amazon Web Services account \cr
#'  \link[=s3control_describe_job]{describe_job} \tab Retrieves the configuration parameters and status for a Batch Operations job \cr
#'  \link[=s3control_get_access_point]{get_access_point} \tab Returns configuration information about the specified access point \cr
#'  \link[=s3control_get_access_point_policy]{get_access_point_policy} \tab Returns the access point policy associated with the specified access point \cr
#'  \link[=s3control_get_access_point_policy_status]{get_access_point_policy_status} \tab Indicates whether the specified access point currently has a policy that allows public access \cr
#'  \link[=s3control_get_job_tagging]{get_job_tagging} \tab Returns the tags on an Amazon S3 Batch Operations job \cr
#'  \link[=s3control_get_public_access_block]{get_public_access_block} \tab Retrieves the PublicAccessBlock configuration for an Amazon Web Services account \cr
#'  \link[=s3control_list_access_points]{list_access_points} \tab Returns a list of the access points currently associated with the specified bucket \cr
#'  \link[=s3control_list_jobs]{list_jobs} \tab Lists current Amazon S3 Batch Operations jobs and jobs that have ended within the last 30 days for the AWS account making the request\cr
#'  \link[=s3control_put_access_point_policy]{put_access_point_policy} \tab Associates an access policy with the specified access point \cr
#'  \link[=s3control_put_job_tagging]{put_job_tagging} \tab Set the supplied tag-set on an Amazon S3 Batch Operations job \cr
#'  \link[=s3control_put_public_access_block]{put_public_access_block} \tab Creates or modifies the PublicAccessBlock configuration for an Amazon Web Services account \cr
#'  \link[=s3control_update_job_priority]{update_job_priority} \tab Updates an existing Amazon S3 Batch Operations job's priority \cr
#'  \link[=s3control_update_job_status]{update_job_status} \tab Updates the status for the specified job 
#' }
#'
#' @rdname s3control
#' @export
s3control <- function(config = list()) {
  svc <- .s3control$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.s3control <- list()

.s3control$operations <- list()

.s3control$metadata <- list(
  service_name = "s3control",
  endpoints = list("*" = list(endpoint = "s3control.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "s3control.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "s3control.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "s3control.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "S3 Control",
  api_version = "2018-08-20",
  signing_name = "s3",
  json_version = "",
  target_prefix = ""
)

.s3control$service <- function(config = list()) {
  handlers <- new_handlers("restxml", "s3v4")
  new_service(.s3control$metadata, handlers, config)
}
