% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_list_parts}
\alias{s3_list_parts}
\title{Lists the parts that have been uploaded for a specific multipart upload}
\usage{
s3_list_parts(Bucket, Key, MaxParts, PartNumberMarker, UploadId,
  RequestPayer)
}
\arguments{
\item{Bucket}{[required]}

\item{Key}{[required]}

\item{MaxParts}{Sets the maximum number of parts to return.}

\item{PartNumberMarker}{Specifies the part after which listing should begin. Only parts with
higher part numbers will be listed.}

\item{UploadId}{[required] Upload ID identifying the multipart upload whose parts are being listed.}

\item{RequestPayer}{}
}
\description{
Lists the parts that have been uploaded for a specific multipart upload.
}
\section{Request syntax}{
\preformatted{svc$list_parts(
  Bucket = "string",
  Key = "string",
  MaxParts = 123,
  PartNumberMarker = 123,
  UploadId = "string",
  RequestPayer = "requester"
)
}
}

\examples{
# The following example lists parts uploaded for a specific multipart
# upload.
\donttest{svc$list_parts(
  Bucket = "examplebucket",
  Key = "bigobject",
  UploadId = "example7YPBOJuoFiQ9cz4P3Pe6FIZwO4f7wN93uHsNBEw97pl5eNwzExg0LAT2dUN91cOmrEQHDsP..."
)}

}
\keyword{internal}
