% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efs_operations.R
\name{efs_delete_tags}
\alias{efs_delete_tags}
\title{Deletes the specified tags from a file system}
\usage{
efs_delete_tags(FileSystemId, TagKeys)
}
\arguments{
\item{FileSystemId}{[required] The ID of the file system whose tags you want to delete (String).}

\item{TagKeys}{[required] A list of tag keys to delete.}
}
\description{
Deletes the specified tags from a file system. If the \code{DeleteTags}
request includes a tag key that doesn't exist, Amazon EFS ignores it
and doesn't cause an error. For more information about tags and related
restrictions, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html}{Tag Restrictions}
in the \emph{AWS Billing and Cost Management User Guide}.
}
\details{
This operation requires permissions for the
\code{elasticfilesystem:DeleteTags} action.
}
\section{Request syntax}{
\preformatted{svc$delete_tags(
  FileSystemId = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\examples{
# This operation deletes tags for an EFS file system.
\donttest{svc$delete_tags(
  FileSystemId = "fs-01234567",
  TagKeys = list(
    "Name"
  )
)}

}
\keyword{internal}
