% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_list_backup_vaults}
\alias{backup_list_backup_vaults}
\title{Returns a list of recovery point storage containers along with
information about them}
\usage{
backup_list_backup_vaults(NextToken, MaxResults)
}
\arguments{
\item{NextToken}{The next item following a partial list of returned items. For example,
if a request is made to return \code{maxResults} number of items, \code{NextToken}
allows you to return more items in your list starting at the location
pointed to by the next token.}

\item{MaxResults}{The maximum number of items to be returned.}
}
\value{
A list with the following syntax:\preformatted{list(
  BackupVaultList = list(
    list(
      BackupVaultName = "string",
      BackupVaultArn = "string",
      CreationDate = as.POSIXct(
        "2015-01-01"
      ),
      EncryptionKeyArn = "string",
      CreatorRequestId = "string",
      NumberOfRecoveryPoints = 123
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns a list of recovery point storage containers along with
information about them.
}
\section{Request syntax}{
\preformatted{svc$list_backup_vaults(
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
