% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_get_job_tagging}
\alias{s3control_get_job_tagging}
\title{Returns the tags on an S3 Batch Operations job}
\usage{
s3control_get_job_tagging(AccountId, JobId)
}
\arguments{
\item{AccountId}{[required] The AWS account ID associated with the S3 Batch Operations job.}

\item{JobId}{[required] The ID for the S3 Batch Operations job whose tags you want to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}
\description{
Returns the tags on an S3 Batch Operations job. To use this operation,
you must have permission to perform the \code{s3:GetJobTagging} action. For
more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops-managing-jobs.html#batch-ops-job-tags}{Controlling access and labeling jobs using tags}
in the \emph{Amazon Simple Storage Service Developer Guide}.

Related actions include:
\itemize{
\item \code{\link[=s3control_create_job]{create_job}}
\item \code{\link[=s3control_put_job_tagging]{put_job_tagging}}
\item \code{\link[=s3control_delete_job_tagging]{delete_job_tagging}}
}
}
\section{Request syntax}{
\preformatted{svc$get_job_tagging(
  AccountId = "string",
  JobId = "string"
)
}
}

\keyword{internal}
